/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.facets.internal;

import oracle.eclipse.tools.common.util.ProgressMonitorUtil;
import oracle.eclipse.tools.weblogic.applib.AppLibrariesContainer;
import oracle.eclipse.tools.weblogic.descriptors.IApplicationParam;
import oracle.eclipse.tools.weblogic.descriptors.IWebLogicAppDescriptor;
import oracle.eclipse.tools.weblogic.descriptors.WebLogicDescriptorFactory;
import oracle.eclipse.tools.weblogic.internal.WlsCorePlugin;
import oracle.eclipse.tools.weblogic.j2eelib.J2EELibraryToolsFramework;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.sapphire.modeling.ResourceStoreException;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;
import org.eclipse.wst.common.project.facet.core.IDelegate;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;

public final class WlsEarFacetInstallDelegate
implements IDelegate {
    public void execute(IProject project, IProjectFacetVersion fv, Object cfg, IProgressMonitor monitor) throws CoreException {
        ProgressMonitorUtil.beginTask((IProgressMonitor)monitor, (String)"", (int)4);
        try {
            IVirtualComponent vc = ComponentCore.createComponent((IProject)project);
            IVirtualFolder vfolder = vc.getRootFolder();
            IContainer contentroot = vfolder.getUnderlyingFolder();
            IFolder appinf = contentroot.getFolder((IPath)new Path("APP-INF"));
            IFolder appinflib = appinf.getFolder("lib");
            IFolder appinfclasses = appinf.getFolder("classes");
            WlsEarFacetInstallDelegate.mkdirs(appinf);
            WlsEarFacetInstallDelegate.mkdirs(appinflib);
            WlsEarFacetInstallDelegate.mkdirs(appinfclasses);
            ProgressMonitorUtil.worked((IProgressMonitor)monitor, (int)1);
            try {
                IWebLogicAppDescriptor descriptor = WebLogicDescriptorFactory.getAppDescriptor(project);
                descriptor.setServerVersion(fv.getVersionString());
                IApplicationParam param = (IApplicationParam)descriptor.getApplicationParams().insert();
                param.setName("webapp.encoding.default");
                param.setValue("UTF-8");
                descriptor.resource().save();
                descriptor.dispose();
            }
            catch (ResourceStoreException e) {
                throw new CoreException(WlsCorePlugin.createErrorStatus((Exception)((Object)e)));
            }
            ProgressMonitorUtil.worked((IProgressMonitor)monitor, (int)1);
            IVirtualReference[] iVirtualReferenceArray = vc.getReferences();
            int n = iVirtualReferenceArray.length;
            int n2 = 0;
            while (n2 < n) {
                IVirtualReference ref = iVirtualReferenceArray[n2];
                IVirtualComponent refcomp = ref.getReferencedComponent();
                if (!refcomp.isBinary()) {
                    IProject refpj = refcomp.getProject();
                    AppLibrariesContainer.addToClasspath(refpj, project);
                }
                ++n2;
            }
            ProgressMonitorUtil.worked((IProgressMonitor)monitor, (int)1);
            J2EELibraryToolsFramework.addValidationBuilder(project.getProject());
            ProgressMonitorUtil.worked((IProgressMonitor)monitor, (int)1);
        }
        finally {
            ProgressMonitorUtil.done((IProgressMonitor)monitor);
        }
    }

    private static void mkdirs(IFolder folder) throws CoreException {
        if (!folder.exists()) {
            if (folder.getParent() instanceof IFolder) {
                WlsEarFacetInstallDelegate.mkdirs((IFolder)folder.getParent());
            }
            folder.create(true, true, null);
        }
    }
}

