/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.facets;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import oracle.eclipse.tools.common.util.wtp.WtpProjectUtil;
import oracle.eclipse.tools.weblogic.descriptors.IModuleDefinition;
import oracle.eclipse.tools.weblogic.descriptors.IWebLogicAppDescriptor;
import oracle.eclipse.tools.weblogic.descriptors.ModuleType;
import oracle.eclipse.tools.weblogic.descriptors.WebLogicDescriptorFactory;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jst.j2ee.application.internal.operations.AddComponentToEnterpriseApplicationDataModelProvider;
import org.eclipse.jst.j2ee.internal.plugin.J2EEPlugin;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;

public final class WlsGarFacet {
    public static final String ID = "oracle.coherence.gar";
    public static final IProjectFacet FACET = ProjectFacetsManager.getProjectFacet((String)"oracle.coherence.gar");
    public static final IProjectFacetVersion VERSION_12_1_2 = FACET.getVersion("12.1.2");

    public static boolean isInstalled(IProject project) {
        return WtpProjectUtil.hasProjectFacet((IProject)project, (IProjectFacet)FACET);
    }

    public static IProjectFacetVersion getProjectFacet(IProject project) {
        try {
            IFacetedProject fproj = ProjectFacetsManager.create((IProject)project);
            if (fproj != null) {
                return fproj.getProjectFacetVersion(FACET);
            }
        }
        catch (CoreException e) {
            LoggingService.logException((String)"oracle.eclipse.tools.weblogic", (CoreException)e);
        }
        return null;
    }

    public static void updateGarModuleDependency(IProject earProject) {
        IWebLogicAppDescriptor webLogicAppDescriptor = WebLogicDescriptorFactory.getAppDescriptor(earProject);
        if (webLogicAppDescriptor == null) {
            return;
        }
        IVirtualComponent earComp = ComponentCore.createComponent((IProject)earProject);
        HashSet<String> garNames = new HashSet<String>();
        for (IModuleDefinition m : webLogicAppDescriptor.getModules()) {
            String garPath;
            if (m.getType().content() != ModuleType.GAR || (garPath = (String)m.getGarPath().content()) == null) continue;
            garNames.add(garPath);
        }
        IVirtualReference[] oldReferences = earComp.getReferences();
        ArrayList<IVirtualReference> list = new ArrayList<IVirtualReference>();
        IVirtualReference[] iVirtualReferenceArray = oldReferences;
        int n = oldReferences.length;
        int n2 = 0;
        while (n2 < n) {
            block9: {
                IVirtualReference ref;
                block8: {
                    ref = iVirtualReferenceArray[n2];
                    String path = ref.getArchiveName();
                    String runtimePath = ref.getRuntimePath().toPortableString();
                    if (path == null || !path.endsWith(".gar")) break block8;
                    if (!garNames.contains(path) || runtimePath.equals("/lib")) break block9;
                    garNames.remove(path);
                }
                list.add(ref);
            }
            ++n2;
        }
        if (oldReferences.length != list.size()) {
            earComp.setReferences(list.toArray(new IVirtualReference[list.size()]));
        }
        for (String newGarModulePath : garNames) {
            IProject moduleProject;
            if (!newGarModulePath.endsWith(".gar") || (moduleProject = ResourcesPlugin.getWorkspace().getRoot().getProject(newGarModulePath.substring(0, newGarModulePath.indexOf(46)))) == null || !moduleProject.exists()) continue;
            IVirtualComponent c = ComponentCore.createComponent((IProject)moduleProject);
            WlsGarFacet.addToEar(earComp, c, newGarModulePath);
        }
        webLogicAppDescriptor.dispose();
    }

    private static void addToEar(IVirtualComponent earComp, IVirtualComponent j2eeComp, String moduleURI) {
        IDataModel dataModel = DataModelFactory.createDataModel((IDataModelProvider)new AddComponentToEnterpriseApplicationDataModelProvider());
        Map map = (Map)dataModel.getProperty("ICreateReferenceComponentsDataModelProperties.TARGET_COMPONENTS_TO_URI_MAP");
        map.put(j2eeComp, moduleURI);
        dataModel.setProperty("ICreateReferenceComponentsDataModelProperties.SOURCE_COMPONENT", (Object)earComp);
        List modList = (List)dataModel.getProperty("ICreateReferenceComponentsDataModelProperties.TARGET_COMPONENT");
        modList.add(j2eeComp);
        dataModel.setProperty("ICreateReferenceComponentsDataModelProperties.TARGET_COMPONENT", (Object)modList);
        try {
            dataModel.getDefaultOperation().execute(null, null);
        }
        catch (ExecutionException e) {
            J2EEPlugin.logError((Throwable)e);
        }
    }
}

