/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.facets;

import oracle.eclipse.tools.common.util.logging.LoggingService;
import oracle.eclipse.tools.common.util.wtp.FacetedProjectMetadata;
import oracle.eclipse.tools.common.util.wtp.WtpProjectUtil;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;

public final class WlsEjbGenFacet {
    public static final String ID = "wlw.ejb";
    public static final String VERSION_2_1 = "2.1";
    public static final String VERSION_9_2 = "9.2";
    public static final String VERSION_10_0 = "10.0";
    public static final String VERSION_10_3 = "10.3";
    public static final String VERSION_10_3_1 = "10.3.1";
    public static final IProjectFacet FACET = ProjectFacetsManager.getProjectFacet((String)"wlw.ejb");

    public static boolean isInstalled(IProject project) {
        return WtpProjectUtil.hasProjectFacet((IProject)project, (IProjectFacet)FACET);
    }

    public static boolean is21Installed(IProject project) {
        return WlsEjbGenFacet.hasVersion(project, VERSION_2_1);
    }

    public static boolean is92Installed(IProject project) {
        return WlsEjbGenFacet.hasVersion(project, VERSION_9_2);
    }

    public static boolean is10Installed(IProject project) {
        return WlsEjbGenFacet.hasVersion(project, VERSION_10_0);
    }

    public static boolean is10_3Installed(IProject project) {
        return WlsEjbGenFacet.hasVersion(project, VERSION_10_3);
    }

    private static boolean hasVersion(IProject project, String version) {
        FacetedProjectMetadata md;
        if (!FacetedProjectMetadata.isFacetedProject((IProject)project)) {
            return false;
        }
        try {
            md = new FacetedProjectMetadata(project);
        }
        catch (CoreException ce) {
            LoggingService.logException((String)"oracle.eclipse.tools.weblogic", (CoreException)ce);
            return false;
        }
        for (FacetedProjectMetadata.InstalledFacet ifacet : md.getInstalledFacets()) {
            if (!WlsEjbGenFacet.checkFacetVersion(ifacet, version)) continue;
            return true;
        }
        return false;
    }

    public static boolean checkFacetVersion(FacetedProjectMetadata.InstalledFacet ifacet, String version) {
        return ifacet.getFacetId().equals(ID) && ifacet.getVersion().equals(version);
    }
}

