/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.ejb.upgrade;

import java.util.Set;
import oracle.eclipse.tools.common.upgrade.AbstractProjectUpgradeParticipant;
import oracle.eclipse.tools.common.upgrade.IProjectUpgradeParticipant;
import oracle.eclipse.tools.common.util.wtp.FacetedProjectMetadata;
import oracle.eclipse.tools.weblogic.facets.WlsEjbGenFacet;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;

public final class EJBFacetUpgradeParticipant
extends AbstractProjectUpgradeParticipant {
    public boolean check(IProject project) throws CoreException {
        return WlsEjbGenFacet.is21Installed(project);
    }

    protected void prepare(IProject project, Set<IProjectUpgradeParticipant.Action> actions) {
        IFile f = project.getFile(".settings/org.eclipse.wst.common.project.facet.core.xml");
        actions.add(new IProjectUpgradeParticipant.Action(IProjectUpgradeParticipant.Action.Type.EDIT, f));
    }

    public void execute(IProject project, IProgressMonitor monitor) throws CoreException {
        if (!FacetedProjectMetadata.isFacetedProject((IProject)project)) {
            return;
        }
        FacetedProjectMetadata md = new FacetedProjectMetadata(project);
        boolean modified = false;
        for (FacetedProjectMetadata.InstalledFacet ifacet : md.getInstalledFacets()) {
            if (!WlsEjbGenFacet.checkFacetVersion(ifacet, "2.1")) continue;
            ifacet.setVersion("9.2");
            modified = true;
        }
        if (modified) {
            md.save(project);
        }
    }
}

