/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.ejb.publish;

import java.util.List;
import oracle.eclipse.tools.weblogic.ejb.EJBProjectMessages;
import oracle.eclipse.tools.weblogic.ejb.IEJBCRunner;
import oracle.eclipse.tools.weblogic.facets.WlsEjbGenFacet;
import oracle.eclipse.tools.weblogic.server.IWeblogicServer;
import oracle.eclipse.tools.weblogic.server.IWlsDeployRuntime;
import oracle.eclipse.tools.weblogic.server.WlsDeployRuntimeFactory;
import oracle.eclipse.tools.weblogic.server.model.IWeblogicModule;
import oracle.eclipse.tools.weblogic.server.model.WeblogicPublishOperation;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.model.PublishOperation;
import org.eclipse.wst.server.core.model.PublishTaskDelegate;

public class EJBGenProjectPublishTask
extends PublishTaskDelegate {
    public static final String WLS_100_ID = "oracle.eclipse.tools.weblogic.ejb.ejbGenPublishTask100";
    public static final String WLS_92_ID = "oracle.eclipse.tools.weblogic.ejb.ejbGenPublishTask92";

    public PublishOperation[] getTasks(IServer server, List modules) {
        IWeblogicServer ws = (IWeblogicServer)server.loadAdapter(IWeblogicServer.class, null);
        if (ws == null || modules == null || modules.isEmpty()) {
            return new PublishOperation[0];
        }
        return new PublishOperation[]{new Task(server)};
    }

    private static class Task
    extends WeblogicPublishOperation {
        public Task(IServer server) {
            super(EJBProjectMessages.EJBGenProjectPublishTaskEJBProjectTaskName, EJBProjectMessages.EJBGenProjectPublishTaskEJBGenProjectTaskDescription, server);
        }

        public int getOrder() {
            return 0;
        }

        @Override
        protected void processRootModule(IWeblogicModule rootWLModule, IProgressMonitor monitor) throws CoreException {
            if (!this.isModuleAccessible(rootWLModule)) {
                return;
            }
            IModule rootModule = rootWLModule.getModule();
            if (this.isEARModule(rootModule)) {
                List<IWeblogicModule> childModules = rootWLModule.getChildModules();
                for (IWeblogicModule childModule : childModules) {
                    this.processModule(childModule, monitor);
                }
            } else {
                this.processModule(rootWLModule, monitor);
            }
        }

        private boolean isEARModule(IModule module) {
            return module.getModuleType().getId().equals("jst.ear");
        }

        private boolean isEJBGenModule(IModule module) {
            IProject project = module.getProject();
            return WlsEjbGenFacet.isInstalled(project);
        }

        protected void processModule(IWeblogicModule wlModule, IProgressMonitor monitor) throws CoreException {
            if (!this.isModuleAccessible(wlModule)) {
                return;
            }
            IModule module = wlModule.getModule();
            if (this.isEJBGenModule(module) && Task.hasChanges(wlModule)) {
                IProject project = module.getProject();
                IWlsDeployRuntime runtime = WlsDeployRuntimeFactory.create(project);
                if (runtime == null) {
                    throw new CoreException((IStatus)new Status(4, "oracle.eclipse.tools.weblogic", 0, EJBProjectMessages.EJBRuntimeMissing, null));
                }
                IEJBCRunner runner = runtime.getEJBCRunner();
                runner.executeEJBC(project, monitor);
                this.setBuildFolderDerived(module, monitor);
            }
        }

        private boolean isModuleAccessible(IWeblogicModule wlModule) {
            return wlModule.getKind() != 3;
        }
    }
}

