/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.ejb.export;

import oracle.eclipse.tools.common.util.logging.LoggingService;
import oracle.eclipse.tools.weblogic.ejb.EJBProjectMessages;
import oracle.eclipse.tools.weblogic.ejb.IEJBCRunner;
import oracle.eclipse.tools.weblogic.facets.WlsEjbGenFacet;
import oracle.eclipse.tools.weblogic.server.IWlsDeployRuntime;
import oracle.eclipse.tools.weblogic.server.WlsDeployRuntimeFactory;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;

public class EJBPreExportOp
extends AbstractDataModelOperation {
    public EJBPreExportOp() {
    }

    public EJBPreExportOp(IDataModel dataModel) {
        super(dataModel);
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        block3: {
            SubProgressMonitor subMonitor = new SubProgressMonitor(monitor, -1);
            IVirtualComponent component = (IVirtualComponent)this.model.getProperty("IJ2EEComponentExportDataModelProperties.COMPONENT");
            try {
                IProject project = component.getProject();
                if (!WlsEjbGenFacet.isInstalled(project)) break block3;
                IWlsDeployRuntime runtime = WlsDeployRuntimeFactory.create(project);
                if (runtime != null) {
                    IEJBCRunner runner = runtime.getEJBCRunner();
                    runner.executeEJBC(project, (IProgressMonitor)subMonitor);
                    break block3;
                }
                String msg = EJBProjectMessages.EJBRuntimeMissing;
                LoggingService.logError((String)"oracle.eclipse.tools.weblogic", (String)msg);
                return new Status(4, "oracle.eclipse.tools.weblogic", 0, msg, null);
            }
            catch (CoreException e) {
                String msg = EJBProjectMessages.EJBPreExportOpEJBGenFailure;
                LoggingService.logException((String)"oracle.eclipse.tools.weblogic", (Throwable)e, (String)msg);
                return new Status(4, "oracle.eclipse.tools.weblogic", 0, msg, (Throwable)e);
            }
        }
        return OK_STATUS;
    }

    public boolean canRedo() {
        return false;
    }

    public boolean canUndo() {
        return false;
    }
}

