/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.ejb.builder;

import java.util.HashSet;
import java.util.Set;
import oracle.eclipse.tools.common.builder.AbstractBuilder;
import oracle.eclipse.tools.common.builder.IBuilderPrefs;
import oracle.eclipse.tools.common.builder.IBuilderState;
import oracle.eclipse.tools.common.builder.ICleaner;
import oracle.eclipse.tools.common.builder.IFullBuilder;
import oracle.eclipse.tools.common.builder.IIncrementalBuilder;
import oracle.eclipse.tools.common.util.jdt.JavaProjectUtil;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import oracle.eclipse.tools.weblogic.ejb.EJBCoreUtil;
import oracle.eclipse.tools.weblogic.ejb.EJBProjectMessages;
import oracle.eclipse.tools.weblogic.ejb.IEJBGenRunner;
import oracle.eclipse.tools.weblogic.internal.WlsCorePlugin;
import oracle.eclipse.tools.weblogic.server.IWlsDeployRuntime;
import oracle.eclipse.tools.weblogic.server.WlsDeployRuntimeFactory;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jst.j2ee.ejb.componentcore.util.EJBArtifactEdit;
import org.eclipse.osgi.util.NLS;

public final class EJBGenBuilder
extends AbstractBuilder
implements IIncrementalBuilder,
IFullBuilder {
    public static final String ID = "oracle.eclipse.tools.weblogic.EJBGenBuilder";
    private boolean wlwEJBsAddedRemoved = false;
    private IProgressMonitor monitor;

    protected IBuilderState createBuilderState() {
        return null;
    }

    protected IBuilderPrefs createBuilderPrefs() {
        return null;
    }

    protected ICleaner createCleaner() {
        return null;
    }

    protected IIncrementalBuilder createIncrementalBuilder() {
        return this;
    }

    protected IFullBuilder createFullBuilder() {
        return this;
    }

    protected boolean isAccessible(IProject project) {
        HashSet<IProject> projectsProcessed = new HashSet<IProject>();
        boolean accessible = this.internalIsAccessible(project, projectsProcessed);
        if (!accessible && super.isAccessible(project)) {
            try {
                project.deleteMarkers("oracle.eclipse.tools.weblogic.ejbgenProblem", true, 0);
                EJBCoreUtil.createMarker((IResource)project, 2, NLS.bind((String)EJBProjectMessages.projectMissingJavaNature, (Object)project.getName()));
            }
            catch (CoreException coreException) {}
            this.forgetLastBuiltState();
        }
        return accessible;
    }

    protected boolean checkHelpers() {
        return true;
    }

    private boolean internalIsAccessible(IProject project, Set<IProject> projectsProcessed) {
        boolean isAccessible = true;
        if (!super.isAccessible(project)) {
            return !projectsProcessed.isEmpty();
        }
        if (!JavaProjectUtil.isJavaProject((IProject)project)) {
            return false;
        }
        IJavaProject jproj = JavaCore.create((IProject)project);
        if (jproj == null) {
            return false;
        }
        IWorkspaceRoot root = jproj.getProject().getWorkspace().getRoot();
        try {
            IClasspathEntry[] classpathEntries;
            IClasspathEntry[] iClasspathEntryArray = classpathEntries = jproj.getResolvedClasspath(true);
            int n = classpathEntries.length;
            int n2 = 0;
            while (n2 < n) {
                IClasspathEntry entry = iClasspathEntryArray[n2];
                if (entry.getEntryKind() == 2) {
                    IPath otherProjectPath = entry.getPath();
                    IProject otherProject = root.getProject(otherProjectPath.segment(0));
                    if (!projectsProcessed.contains(project)) {
                        projectsProcessed.add(project);
                        if (!this.internalIsAccessible(otherProject, projectsProcessed)) {
                            isAccessible = false;
                        }
                    }
                }
                ++n2;
            }
        }
        catch (JavaModelException javaModelException) {
            return false;
        }
        return isAccessible;
    }

    public void fullBuild(IProgressMonitor monitor) throws CoreException {
        if (monitor != null) {
            monitor.beginTask(this.getBeginResource(), this.getProgressSize());
        }
        try {
            this.clean(monitor);
            this.executeEJBGen(this.getProject(), monitor);
        }
        catch (CoreException ce) {
            LoggingService.logException((Plugin)WlsCorePlugin.getInstance(), (CoreException)ce);
        }
        if (monitor != null) {
            monitor.done();
        }
    }

    protected void clean(IProgressMonitor monitor) throws CoreException {
        this.clearMarkers();
        EJBCoreUtil.deleteGeneratedDDs(this.getProject(), EJBCoreUtil.EjbJarHandling.LEAVE);
    }

    private void clearMarkers() throws CoreException {
        this.getProject().deleteMarkers("oracle.eclipse.tools.weblogic.ejbgenProblem", true, 0);
    }

    private void loadEJBJarResource() {
        EJBArtifactEdit ejbEdit = new EJBArtifactEdit(this.getProject(), true, false);
        try {
            ejbEdit.getEJBJar();
        }
        finally {
            ejbEdit.dispose();
        }
    }

    public String getBeginResource() {
        return EJBProjectMessages.EJBGenBuilder;
    }

    public int getProgressSize() {
        return 2;
    }

    public boolean visit(IResource resource) throws CoreException {
        return false;
    }

    public void preTraversal(IProgressMonitor progressMonitor) throws CoreException {
        this.wlwEJBsAddedRemoved = false;
        this.monitor = progressMonitor;
    }

    public boolean visit(IResourceDelta delta) throws CoreException {
        int kind = delta.getKind();
        IResource resource = delta.getResource();
        IPath aptOutputDir = EJBCoreUtil.getAPTOutputFolder(this.getProject()).getLocation();
        if (resource.getLocation().equals((Object)aptOutputDir)) {
            return false;
        }
        if (resource.getType() == 1) {
            IFile file = (IFile)resource;
            if (kind == 1 || kind == 4) {
                try {
                    if (EJBCoreUtil.isEJBGenSrc(file)) {
                        this.wlwEJBsAddedRemoved = true;
                    }
                }
                catch (CoreException coreException) {}
            } else if (kind == 2 && (file.getName().endsWith(".java") || file.getFullPath().removeLastSegments(1).lastSegment().equals("META-INF"))) {
                this.wlwEJBsAddedRemoved = true;
            }
            return false;
        }
        return true;
    }

    public void postTraversal() throws CoreException {
        if (this.wlwEJBsAddedRemoved) {
            try {
                this.clearMarkers();
                this.executeEJBGen(this.getProject(), this.monitor);
            }
            catch (CoreException ce) {
                LoggingService.logException((Plugin)WlsCorePlugin.getInstance(), (CoreException)ce);
            }
        }
    }

    private void executeEJBGen(IProject project, IProgressMonitor monitor) throws CoreException {
        IWlsDeployRuntime runtime = WlsDeployRuntimeFactory.create(project);
        if (runtime != null) {
            IEJBGenRunner runner = runtime.getEJBGenRunner();
            runner.executeEJBGen(project, monitor);
        } else {
            EJBCoreUtil.createMarker((IResource)project, 2, EJBProjectMessages.EJBRuntimeMissing);
            this.forgetLastBuiltState();
        }
    }
}

