/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.ejb;

import java.util.Iterator;
import java.util.Map;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import oracle.eclipse.tools.weblogic.internal.WlsCorePlugin;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jdt.apt.core.util.AptConfig;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.osgi.service.prefs.BackingStoreException;

public class EJBProjectProperties {
    private static final String EJBGEN = "ejbgen";
    public static final String PROPERTY_EJB_PRE = "ejbgenejbPrefix";
    public static final String PROPERTY_EJB_SUF = "ejbgenejbSuffix";
    public static final String PROPERTY_LOCALHOME_PRE = "ejbgenlocalHomePrefix";
    public static final String PROPERTY_LOCALHOME_SUF = "ejbgenlocalHomeSuffix";
    public static final String PROPERTY_REMOTEHOME_PRE = "ejbgenremoteHomePrefix";
    public static final String PROPERTY_REMOTEHOME_SUF = "ejbgenremoteHomeSuffix";
    public static final String PROPERTY_LOCALINT_PRE = "ejbgenlocalPrefix";
    public static final String PROPERTY_LOCALINT_SUF = "ejbgenlocalSuffix";
    public static final String PROPERTY_REMOTEINT_PRE = "ejbgenremotePrefix";
    public static final String PROPERTY_REMOTEINT_SUF = "ejbgenremoteSuffix";
    public static final String PROPERTY_VALUE_PRE = "ejbgenvalueObjectPrefix";
    public static final String PROPERTY_VALUE_SUF = "ejbgenvalueObjectSuffix";
    public static final String PROPERTY_EJBC_FLAGS = "ejbc.flags";
    private static final String JAR_SETTINGS = "jarSettings.";
    public static final String PROPERTY_JAR_SETTINGS_CREATE_TABLES = "jarSettings.createTables";
    public static final String CREATE_TABLES_UNSPECIFIED = "UNSPECIFIED";
    public static final String CREATE_TABLES_CREATE_ONLY = "CREATE_ONLY";
    public static final String CREATE_TABLES_DISABLED = "DISABLED";
    public static final String CREATE_TABLES_DROP_AND_CREATE = "DROP_AND_CREATE";
    public static final String CREATE_TABLES_DROP_AND_CREATE_ALWAYS = "DROP_AND_CREATE_ALWAYS";
    public static final String CREATE_TABLES_ALTER_OR_CREATE = "ALTER_OR_CREATE";
    public static final String PROPERTY_JAR_SETTINGS_DISABLE_WARNING = "jarSettings.disableWarning";
    public static final String PROPERTY_JAR_SETTINGS_EJB_CLIENT_JAR = "jarSettings.ejbClientJar";
    public static final String PROPERTY_JAR_SETTINGS_ENABLE_BEAN_CLASS_REDEPLOY = "jarSettings.beanClassRedeploy";
    public static final String ENABLE_BEAN_CLASS_REDEPLOY_UNSPECIFIED = "UNSPECIFIED";
    public static final String ENABLE_BEAN_CLASS_REDEPLOY_TRUE = "TRUE";
    public static final String ENABLE_BEAN_CLASS_REDEPLOY_FALSE = "FALSE";
    public static final String[] PROPERTY_NAMES = new String[]{"ejbc.flags", "jarSettings.createTables", "jarSettings.disableWarning", "jarSettings.ejbClientJar", "jarSettings.beanClassRedeploy"};
    public static final String[] TEXT_PROPERTY_NAMES = new String[]{"ejbc.flags", "jarSettings.disableWarning", "jarSettings.ejbClientJar"};
    public static final String[] LIST_PROPERTY_NAMES = new String[]{"jarSettings.createTables", "jarSettings.beanClassRedeploy"};
    private static final String PREFS_NODE_ID = "com.bea.wlw.ejb.core";

    public static void writeProperties(IProject project, final Map<String, String> ejbgenProperties) {
        assert (project != null);
        final IJavaProject jProj = JavaCore.create((IProject)project);
        ProjectScope projectScope = new ProjectScope(project);
        final IEclipsePreferences prefs = projectScope.getNode(PREFS_NODE_ID);
        IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                Iterator iter = ejbgenProperties.keySet().iterator();
                LoggingService.logDebug((Plugin)WlsCorePlugin.getInstance(), (String)"EJBProjectProperties.writeProperties, about to save APT options");
                while (iter.hasNext()) {
                    String key = (String)iter.next();
                    String pref = (String)ejbgenProperties.get(key);
                    if (key.startsWith(EJBProjectProperties.EJBGEN) || key.startsWith(EJBProjectProperties.JAR_SETTINGS)) {
                        if (pref != null) {
                            AptConfig.addProcessorOption((IJavaProject)jProj, (String)key, (String)pref);
                            continue;
                        }
                        AptConfig.removeProcessorOption((IJavaProject)jProj, (String)key);
                        continue;
                    }
                    if (pref != null) {
                        prefs.put(key, pref);
                        continue;
                    }
                    prefs.remove(key);
                }
                LoggingService.logDebug((Plugin)WlsCorePlugin.getInstance(), (String)"EJBProjectProperties.writeProperties, about to call prefs.flush()");
                try {
                    prefs.flush();
                }
                catch (BackingStoreException e) {
                    LoggingService.logException((Plugin)WlsCorePlugin.getInstance(), (Throwable)e);
                }
            }
        };
        try {
            ResourcesPlugin.getWorkspace().run(runnable, (ISchedulingRule)project, 1, null);
        }
        catch (CoreException ce) {
            LoggingService.logException((Plugin)WlsCorePlugin.getInstance(), (CoreException)ce);
        }
    }

    public static Map<String, String> readProperties(IProject project) {
        IJavaProject jProj = JavaCore.create((IProject)project);
        ProjectScope projectScope = new ProjectScope(project);
        IEclipsePreferences prefs = projectScope.getNode(PREFS_NODE_ID);
        Map props = AptConfig.getProcessorOptions((IJavaProject)jProj);
        Iterator keys = props.keySet().iterator();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            if (key.startsWith(EJBGEN) || key.startsWith(JAR_SETTINGS)) continue;
            keys.remove();
        }
        int i = 0;
        while (i < PROPERTY_NAMES.length) {
            String key = PROPERTY_NAMES[i];
            String pref = prefs.get(key, null);
            if (!key.startsWith(EJBGEN) && !key.startsWith(JAR_SETTINGS) && pref != null) {
                props.put(key, pref);
            }
            ++i;
        }
        return props;
    }
}

