/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.descriptors.operations.internal;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import oracle.eclipse.tools.weblogic.descriptors.IWebLogicWebModuleDescriptor;
import oracle.eclipse.tools.weblogic.descriptors.WebLogicDescriptorFactory;
import oracle.eclipse.tools.weblogic.descriptors.operations.ICreateWebModuleDescriptorOp;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sapphire.modeling.ProgressMonitor;
import org.eclipse.sapphire.modeling.ResourceStoreException;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.modeling.xml.XmlResource;
import org.eclipse.sapphire.platform.StatusBridge;

public class CreateWebModuleDescriptorOpMethods {
    public static Status execute(ICreateWebModuleDescriptorOp operation, ProgressMonitor monitor) {
        if (monitor == null) {
            monitor = new ProgressMonitor();
        }
        monitor.beginTask(Resources.executeTaskName, 3);
        try {
            IFile newFileHandle = (IFile)operation.getFile().resolve();
            try {
                newFileHandle.refreshLocal(0, (IProgressMonitor)new NullProgressMonitor());
                if (newFileHandle.exists()) {
                    newFileHandle.setContents((InputStream)new ByteArrayInputStream(new byte[0]), 1, (IProgressMonitor)new NullProgressMonitor());
                }
            }
            catch (CoreException e) {
                Status status = StatusBridge.create((IStatus)e.getStatus());
                monitor.done();
                return status;
            }
            monitor.worked(1);
            try {
                IWebLogicWebModuleDescriptor model = WebLogicDescriptorFactory.getWebDescriptor(newFileHandle);
                ((XmlResource)model.adapt(XmlResource.class)).getXmlElement(true);
                model.resource().save();
                model.dispose();
            }
            catch (ResourceStoreException e) {
                Status status = Status.createErrorStatus((Throwable)e);
                monitor.done();
                return status;
            }
            monitor.worked(1);
        }
        finally {
            monitor.done();
        }
        return Status.createOkStatus();
    }

    private static final class Resources
    extends NLS {
        public static String executeTaskName;

        static {
            Resources.initializeMessages((String)CreateWebModuleDescriptorOpMethods.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

