/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.descriptors.operations.internal;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import oracle.eclipse.tools.weblogic.appmodel.IModule;
import oracle.eclipse.tools.weblogic.appmodel.IModuleDependency;
import oracle.eclipse.tools.weblogic.appmodel.IWebLogicJmsConfigRef;
import oracle.eclipse.tools.weblogic.appmodel.IWorkspaceModel;
import oracle.eclipse.tools.weblogic.appmodel.WorkspaceModelFactory;
import oracle.eclipse.tools.weblogic.descriptors.IModuleDefinition;
import oracle.eclipse.tools.weblogic.descriptors.IWebLogicAppDescriptor;
import oracle.eclipse.tools.weblogic.descriptors.IWebLogicJmsModuleDescriptor;
import oracle.eclipse.tools.weblogic.descriptors.ModuleType;
import oracle.eclipse.tools.weblogic.descriptors.WebLogicDescriptorFactory;
import oracle.eclipse.tools.weblogic.descriptors.operations.ICreateWebLogicJmsConfigOp;
import oracle.eclipse.tools.weblogic.descriptors.operations.WebLogicJmsConfigAssociationMethod;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sapphire.modeling.Path;
import org.eclipse.sapphire.modeling.ProgressMonitor;
import org.eclipse.sapphire.modeling.ResourceStoreException;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.modeling.xml.XmlResource;
import org.eclipse.sapphire.platform.StatusBridge;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;

public class CreateWebLogicJmsConfigOpMethods {
    public static Status execute(ICreateWebLogicJmsConfigOp operation, ProgressMonitor monitor) {
        if (monitor == null) {
            monitor = new ProgressMonitor();
        }
        monitor.beginTask(Resources.executeTaskName, 3);
        try {
            IFile newFileHandle = (IFile)operation.getFile().resolve();
            try {
                newFileHandle.refreshLocal(0, (IProgressMonitor)new NullProgressMonitor());
                if (newFileHandle.exists()) {
                    newFileHandle.setContents((InputStream)new ByteArrayInputStream(new byte[0]), 1, (IProgressMonitor)new NullProgressMonitor());
                }
            }
            catch (CoreException e) {
                Status status = StatusBridge.create((IStatus)e.getStatus());
                monitor.done();
                return status;
            }
            monitor.worked(1);
            try {
                IWebLogicJmsModuleDescriptor model = WebLogicDescriptorFactory.getJmsModuleDescriptor(newFileHandle);
                ((XmlResource)model.adapt(XmlResource.class)).getXmlElement(true);
                model.resource().save();
                model.dispose();
            }
            catch (ResourceStoreException e) {
                Status status = Status.createErrorStatus((Throwable)e);
                monitor.done();
                return status;
            }
            monitor.worked(1);
            switch ((WebLogicJmsConfigAssociationMethod)((Object)operation.getAssociationMethod().content())) {
                case REFERENCE_AS_SYSTEM_MODULE: {
                    IWorkspaceModel wsmodel = WorkspaceModelFactory.create();
                    IModule module = wsmodel.getModule((String)operation.getDependentModule().content());
                    Path newFilePath = new Path(newFileHandle.getFullPath().makeRelative().toPortableString());
                    boolean found = false;
                    for (IModuleDependency dep : module.getDependencies()) {
                        Path depPath;
                        if (!(dep instanceof IWebLogicJmsConfigRef) || (depPath = (Path)((IWebLogicJmsConfigRef)dep).getLocation().content()) == null || !depPath.equals((Object)newFilePath)) continue;
                        found = true;
                        break;
                    }
                    if (!found) {
                        IModuleDependency dep;
                        dep = (IWebLogicJmsConfigRef)module.getDependencies().insert(IWebLogicJmsConfigRef.TYPE);
                        dep.setLocation(newFilePath);
                        try {
                            wsmodel.resource().save();
                        }
                        catch (ResourceStoreException e) {
                            Status status = Status.createErrorStatus((Throwable)e);
                            monitor.done();
                            return status;
                        }
                    }
                    wsmodel.dispose();
                    break;
                }
                case PACKAGE_WITHIN_EAR: {
                    IProject project = newFileHandle.getProject();
                    IWebLogicAppDescriptor descriptor = WebLogicDescriptorFactory.getAppDescriptor(project);
                    String jmsModuleBaseName = operation.getFile().text();
                    int index = jmsModuleBaseName.lastIndexOf(46);
                    if (index > 0) {
                        jmsModuleBaseName = jmsModuleBaseName.substring(0, index);
                    }
                    Path jmsModulePath = CreateWebLogicJmsConfigOpMethods.getRelativePath(project, newFileHandle);
                    int counter = 1;
                    boolean done = false;
                    while (!done) {
                        IModuleDefinition module2;
                        String jmsModuleName = counter == 1 ? jmsModuleBaseName : String.valueOf(jmsModuleBaseName) + "-" + String.valueOf(counter);
                        boolean foundExact = false;
                        boolean foundNameMatch = false;
                        for (IModuleDefinition module2 : descriptor.getModules()) {
                            if (!jmsModuleName.equals(module2.getName().content())) continue;
                            if (jmsModulePath.equals(module2.getPath().content())) {
                                foundExact = true;
                                if (module2.getType().content() == ModuleType.JMS) break;
                                module2.setType(ModuleType.JMS);
                                try {
                                    descriptor.resource().save();
                                    break;
                                }
                                catch (ResourceStoreException e) {
                                    Status status = Status.createErrorStatus((Throwable)e);
                                    monitor.done();
                                    return status;
                                }
                            }
                            foundNameMatch = true;
                            break;
                        }
                        if (foundExact) {
                            done = true;
                            continue;
                        }
                        if (foundNameMatch) {
                            ++counter;
                            continue;
                        }
                        module2 = (IModuleDefinition)descriptor.getModules().insert();
                        module2.setName(jmsModuleName);
                        module2.setType(ModuleType.JMS);
                        module2.setPath(CreateWebLogicJmsConfigOpMethods.getRelativePath(project, newFileHandle));
                        try {
                            descriptor.resource().save();
                        }
                        catch (ResourceStoreException e) {
                            Status status = Status.createErrorStatus((Throwable)e);
                            monitor.done();
                            return status;
                        }
                        done = true;
                    }
                    descriptor.dispose();
                }
            }
            monitor.worked(1);
        }
        finally {
            monitor.done();
        }
        return Status.createOkStatus();
    }

    private static Path getRelativePath(IProject project, IFile file) {
        IVirtualComponent vc = ComponentCore.createComponent((IProject)project);
        if (vc != null) {
            IVirtualFolder root = vc.getRootFolder();
            IContainer[] iContainerArray = root.getUnderlyingFolders();
            int n = iContainerArray.length;
            int n2 = 0;
            while (n2 < n) {
                IContainer folder = iContainerArray[n2];
                if (!folder.isDerived() && folder.getLocation().isPrefixOf(file.getLocation())) {
                    return new Path(file.getLocation().makeRelativeTo(folder.getLocation()).toPortableString());
                }
                ++n2;
            }
        }
        return new Path(file.getLocation().toPortableString());
    }

    private static final class Resources
    extends NLS {
        public static String executeTaskName;

        static {
            Resources.initializeMessages((String)CreateWebLogicJmsConfigOpMethods.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

