/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.descriptors.operations.internal;

import oracle.eclipse.tools.common.util.wtp.WtpProjectUtil;
import oracle.eclipse.tools.weblogic.descriptors.operations.ICreateWebLogicJdbcConfigOp;
import oracle.eclipse.tools.weblogic.descriptors.operations.WebLogicJdbcConfigAssociationMethod;
import oracle.eclipse.tools.weblogic.facets.WlsEarFacet;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.PropertyContentEvent;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.services.ValidationService;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;

public final class CreateWebLogicJdbcConfigOpFolderValidator
extends ValidationService {
    protected void initValidationService() {
        ((ICreateWebLogicJdbcConfigOp)this.context(ICreateWebLogicJdbcConfigOp.class)).getAssociationMethod().attach((Listener)new FilteredListener<PropertyContentEvent>(){

            protected void handleTypedEvent(PropertyContentEvent event) {
                CreateWebLogicJdbcConfigOpFolderValidator.this.refresh();
            }
        });
    }

    protected Status compute() {
        Value value = (Value)this.context(Value.class);
        org.eclipse.sapphire.modeling.Path path = (org.eclipse.sapphire.modeling.Path)value.content();
        if (path != null) {
            ICreateWebLogicJdbcConfigOp operation = (ICreateWebLogicJdbcConfigOp)value.element().nearest(ICreateWebLogicJdbcConfigOp.class);
            WebLogicJdbcConfigAssociationMethod method = (WebLogicJdbcConfigAssociationMethod)((Object)operation.getAssociationMethod().content());
            IResource resource = ResourcesPlugin.getWorkspace().getRoot().findMember(path.toPortableString());
            if (resource != null && resource instanceof IContainer) {
                IProject project = resource.getProject();
                if (method == WebLogicJdbcConfigAssociationMethod.REFERENCE_AS_SYSTEM_MODULE) {
                    IVirtualComponent vc = ComponentCore.createComponent((IProject)project);
                    if (CreateWebLogicJdbcConfigOpFolderValidator.isWithinContentFolder(vc, path)) {
                        return Status.createWarningStatus((String)Resources.shouldNotPlaceInContentFolder);
                    }
                } else if (method == WebLogicJdbcConfigAssociationMethod.PACKAGE_WITHIN_EAR) {
                    IVirtualComponent vc = null;
                    if (WtpProjectUtil.isEarProject((IProject)project)) {
                        vc = ComponentCore.createComponent((IProject)project);
                    }
                    if (vc == null) {
                        String msg = NLS.bind((String)Resources.projectNotAnEar, (Object)project.getName());
                        return Status.createErrorStatus((String)msg);
                    }
                    if (!WlsEarFacet.isInstalled(project)) {
                        String msg = NLS.bind((String)Resources.projectWithoutWlsEarExtensions, (Object)project.getName());
                        return Status.createErrorStatus((String)msg);
                    }
                    if (!CreateWebLogicJdbcConfigOpFolderValidator.isWithinContentFolder(vc, path)) {
                        return Status.createErrorStatus((String)Resources.notInEarContentFolder);
                    }
                    if (CreateWebLogicJdbcConfigOpFolderValidator.isWithinAppInfFolder(vc, path)) {
                        return Status.createErrorStatus((String)Resources.inEarAppInfFolder);
                    }
                }
            }
        }
        return Status.createOkStatus();
    }

    private static boolean isWithinContentFolder(IVirtualComponent vc, org.eclipse.sapphire.modeling.Path path) {
        if (vc != null) {
            Path p = new Path(path.toPortableString());
            IContainer[] iContainerArray = vc.getRootFolder().getUnderlyingFolders();
            int n = iContainerArray.length;
            int n2 = 0;
            while (n2 < n) {
                IContainer folder = iContainerArray[n2];
                if (folder.getFullPath().isPrefixOf((IPath)p)) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    private static boolean isWithinAppInfFolder(IVirtualComponent vc, org.eclipse.sapphire.modeling.Path path) {
        if (vc != null) {
            Path p = new Path(path.toPortableString());
            IContainer[] iContainerArray = vc.getRootFolder().getFolder("APP-INF").getUnderlyingFolders();
            int n = iContainerArray.length;
            int n2 = 0;
            while (n2 < n) {
                IContainer folder = iContainerArray[n2];
                if (folder.getFullPath().isPrefixOf((IPath)p)) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    private static final class Resources
    extends NLS {
        public static String projectNotAnEar;
        public static String projectWithoutWlsEarExtensions;
        public static String notInEarContentFolder;
        public static String shouldNotPlaceInContentFolder;
        public static String inEarAppInfFolder;

        static {
            Resources.initializeMessages((String)CreateWebLogicJdbcConfigOpFolderValidator.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

