/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.descriptors.operations.internal;

import oracle.eclipse.tools.weblogic.internal.WlsCorePlugin;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.modeling.Path;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.platform.PathBridge;
import org.eclipse.sapphire.services.ValidationService;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.project.facet.core.FacetedProjectFramework;

public abstract class CreateMetaInfDescriptorOpFolderValidator
extends ValidationService {
    private final String moduleFacetId;
    private final String subFolderName;
    private final String messageTemplate;

    public CreateMetaInfDescriptorOpFolderValidator(String moduleFacetId, String messageTemplate) {
        this(moduleFacetId, "META-INF", messageTemplate);
    }

    public CreateMetaInfDescriptorOpFolderValidator(String moduleFacetId, String subFolderName, String messageTemplate) {
        this.moduleFacetId = moduleFacetId;
        this.subFolderName = subFolderName;
        this.messageTemplate = messageTemplate;
    }

    protected Status compute() {
        IResource resource;
        Value target = (Value)this.context(Value.class);
        Path path = (Path)target.content();
        if (path != null && (resource = ResourcesPlugin.getWorkspace().getRoot().findMember(path.toPortableString())) != null) {
            IProject project = resource.getProject();
            IVirtualComponent vc = null;
            try {
                if (FacetedProjectFramework.hasProjectFacet((IProject)project, (String)this.moduleFacetId)) {
                    vc = ComponentCore.createComponent((IProject)project);
                }
            }
            catch (CoreException e) {
                WlsCorePlugin.logException((Exception)((Object)e));
            }
            boolean ok = false;
            if (vc != null) {
                IPath eclipsePath = PathBridge.create((Path)path);
                IContainer[] iContainerArray = vc.getRootFolder().getFolder(this.subFolderName).getUnderlyingFolders();
                int n = iContainerArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IContainer folder = iContainerArray[n2];
                    if (folder.getFullPath().makeRelative().equals((Object)eclipsePath)) {
                        ok = true;
                        break;
                    }
                    ++n2;
                }
            }
            if (!ok) {
                String msg = NLS.bind((String)this.messageTemplate, (Object)path.toPortableString());
                return Status.createWarningStatus((String)msg);
            }
        }
        return Status.createOkStatus();
    }
}

