/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.descriptors.jms.internal;

import oracle.eclipse.tools.weblogic.descriptors.jms.internal.ValidatorResources;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.modeling.CapitalizationType;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.services.ValidationService;

public class UserGeneratedUOOValidator
extends ValidationService {
    protected Status compute() {
        Value value = (Value)this.context(Value.class);
        String uoo = value.text();
        if (uoo != null && uoo.length() > 0) {
            if (uoo.startsWith(".")) {
                if (!uoo.equals(".System") && !uoo.equals(".Standard")) {
                    String label = value.definition().getLabel(true, CapitalizationType.NO_CAPS, false);
                    return Status.createErrorStatus((String)ValidatorResources.bind((String)ValidatorResources.invalidLabelText, (Object)label, (Object)uoo));
                }
            } else {
                int i = 0;
                while (i < DeployerConstants.DEFAULT_FACTORY_NAMES.length) {
                    if (uoo.equalsIgnoreCase(DeployerConstants.DEFAULT_FACTORY_NAMES[i][1])) {
                        String label = value.definition().getLabel(true, CapitalizationType.NO_CAPS, false);
                        return Status.createErrorStatus((String)ValidatorResources.bind((String)ValidatorResources.invalidLabelText, (Object)label, (Object)uoo));
                    }
                    ++i;
                }
            }
        }
        return Status.createOkStatus();
    }

    private static interface DeployerConstants {
        public static final String[][] DEFAULT_FACTORY_NAMES = new String[][]{{"DefaultConnectionFactory", "weblogic.jms.ConnectionFactory"}, {"DefaultXAConnectionFactory", "weblogic.jms.XAConnectionFactory"}, {"DefaultXAConnectionFactory0", "weblogic.jms.XAConnectionFactory0"}, {"DefaultXAConnectionFactory1", "weblogic.jms.XAConnectionFactory1"}, {"DefaultXAConnectionFactory2", "weblogic.jms.XAConnectionFactory2"}, {"MessageDrivenBeanConnectionFactory", "weblogic.jms.MessageDrivenBeanConnectionFactory"}, {"QueueConnectionFactory", "javax.jms.QueueConnectionFactory"}, {"TopicConnectionFactory", "javax.jms.TopicConnectionFactory"}};
    }
}

