/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.descriptors.jms.internal;

import oracle.eclipse.tools.weblogic.descriptors.IWebLogicJmsModuleDescriptor;
import oracle.eclipse.tools.weblogic.descriptors.jms.INamedEntity;
import oracle.eclipse.tools.weblogic.descriptors.jms.IQueueBase;
import oracle.eclipse.tools.weblogic.descriptors.jms.ITopicBase;
import oracle.eclipse.tools.weblogic.descriptors.jms.internal.ValidatorResources;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.PropertyContentEvent;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.services.ValidationService;

public class UniqueDestinationNameValidator
extends ValidationService {
    private Listener listener;

    protected void initValidationService() {
        super.initValidationService();
        IWebLogicJmsModuleDescriptor descriptor = (IWebLogicJmsModuleDescriptor)this.context(IWebLogicJmsModuleDescriptor.class);
        if (descriptor != null) {
            this.listener = new FilteredListener<PropertyContentEvent>(){

                protected void handleTypedEvent(PropertyContentEvent event) {
                    UniqueDestinationNameValidator.this.refresh();
                }
            };
            descriptor.attach(this.listener, "/Queues/Name");
            descriptor.attach(this.listener, "/Topics/Name");
        }
    }

    public void dispose() {
        super.dispose();
        if (this.listener != null) {
            IWebLogicJmsModuleDescriptor descriptor = (IWebLogicJmsModuleDescriptor)this.context(IWebLogicJmsModuleDescriptor.class);
            descriptor.detach(this.listener, "/Queues/Name");
            descriptor.detach(this.listener, "/Topics/Name");
            this.listener = null;
        }
    }

    protected Status compute() {
        Element descriptor;
        Value value = (Value)this.context(Value.class);
        String str = value.text();
        if (str != null && (descriptor = value.root()) instanceof IWebLogicJmsModuleDescriptor) {
            IWebLogicJmsModuleDescriptor jmsDescriptor = (IWebLogicJmsModuleDescriptor)descriptor;
            INamedEntity thisNamedEntity = (INamedEntity)value.element().nearest(INamedEntity.class);
            if (thisNamedEntity != null) {
                for (IQueueBase queue : jmsDescriptor.getQueues()) {
                    if (thisNamedEntity == queue || !str.equals(queue.getName().text())) continue;
                    return Status.createErrorStatus((String)ValidatorResources.bind((String)ValidatorResources.uniqueNameError, (Object)str));
                }
                for (ITopicBase topic : jmsDescriptor.getTopics()) {
                    if (thisNamedEntity == topic || !str.equals(topic.getName().text())) continue;
                    return Status.createErrorStatus((String)ValidatorResources.bind((String)ValidatorResources.uniqueNameError, (Object)str));
                }
            }
        }
        return Status.createOkStatus();
    }
}

