/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.descriptors.jms.internal;

import oracle.eclipse.tools.weblogic.descriptors.IWebLogicJmsModuleDescriptor;
import oracle.eclipse.tools.weblogic.descriptors.jms.IDestination;
import oracle.eclipse.tools.weblogic.descriptors.jms.IQueue;
import oracle.eclipse.tools.weblogic.descriptors.jms.IQueueBase;
import oracle.eclipse.tools.weblogic.descriptors.jms.ITopic;
import oracle.eclipse.tools.weblogic.descriptors.jms.ITopicBase;
import oracle.eclipse.tools.weblogic.descriptors.jms.internal.ValidatorResources;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.services.ValidationService;

public class UniformDistributedDestinationDeploymentNameValidator
extends ValidationService {
    protected Status compute() {
        Value value = (Value)this.context(Value.class);
        String subdeploymentName = value.text();
        if (subdeploymentName == null || subdeploymentName.length() == 0) {
            return Status.createWarningStatus((String)ValidatorResources.useSubdeployment);
        }
        Element descriptor = value.root();
        if (descriptor instanceof IWebLogicJmsModuleDescriptor) {
            IDestination dest;
            String deploymentName;
            IWebLogicJmsModuleDescriptor jmsDescriptor = (IWebLogicJmsModuleDescriptor)descriptor;
            for (IQueueBase queue : jmsDescriptor.getQueues()) {
                if (queue.type() != IQueue.TYPE || !subdeploymentName.equals(deploymentName = (dest = (IQueue)queue).getSubDeploymentName().text())) continue;
                return Status.createWarningStatus((String)ValidatorResources.bind((String)ValidatorResources.sameSubdeployment, (Object)queue.getName().text()));
            }
            for (ITopicBase topic : jmsDescriptor.getTopics()) {
                if (topic.type() != ITopic.TYPE || !subdeploymentName.equals(deploymentName = (dest = (ITopic)topic).getSubDeploymentName().text())) continue;
                return Status.createWarningStatus((String)ValidatorResources.bind((String)ValidatorResources.sameSubdeployment, (Object)topic.getName().text()));
            }
        }
        return Status.createOkStatus();
    }
}

