/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.descriptors.jms.internal;

import oracle.eclipse.tools.common.util.ObjectUtil;
import oracle.eclipse.tools.weblogic.descriptors.IWebLogicJmsModuleDescriptor;
import oracle.eclipse.tools.weblogic.descriptors.jms.ISAFErrorHandling;
import oracle.eclipse.tools.weblogic.descriptors.jms.ISAFImportedDestinations;
import oracle.eclipse.tools.weblogic.descriptors.jms.ISAFQueue;
import oracle.eclipse.tools.weblogic.descriptors.jms.ISAFTopic;
import oracle.eclipse.tools.weblogic.descriptors.jms.internal.ValidatorResources;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.PropertyContentEvent;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.services.ValidationService;

public class SAFErrorDestinationValuesValidator
extends ValidationService {
    private Listener listener;

    protected void initValidationService() {
        super.initValidationService();
        this.listener = new FilteredListener<PropertyContentEvent>(){

            protected void handleTypedEvent(PropertyContentEvent event) {
                SAFErrorDestinationValuesValidator.this.refresh();
            }
        };
        IWebLogicJmsModuleDescriptor descriptor = (IWebLogicJmsModuleDescriptor)this.context(IWebLogicJmsModuleDescriptor.class);
        descriptor.attach(this.listener, "/SAFErrorHandlers/Name");
        descriptor.attach(this.listener, "/SAFErrorHandlers/SafErrorDestination");
        descriptor.attach(this.listener, "/SafImportedDestinations/SubDeploymentName");
    }

    public void dispose() {
        super.dispose();
        IWebLogicJmsModuleDescriptor descriptor = (IWebLogicJmsModuleDescriptor)this.context(IWebLogicJmsModuleDescriptor.class);
        descriptor.detach(this.listener, "/SAFErrorHandlers/Name");
        descriptor.detach(this.listener, "/SAFErrorHandlers/SafErrorDestination");
        descriptor.detach(this.listener, "/SafImportedDestinations/SubDeploymentName");
    }

    protected Status compute() {
        Value value = (Value)this.context(Value.class);
        String dest = value.text();
        if (dest != null) {
            IWebLogicJmsModuleDescriptor jmsDescriptor;
            ISAFImportedDestinations safDestination;
            ISAFImportedDestinations destination = (ISAFImportedDestinations)value.element().nearest(ISAFImportedDestinations.class);
            String subdeploymentName = destination.getSubDeploymentName().text();
            Element descriptor = value.root();
            if (descriptor instanceof IWebLogicJmsModuleDescriptor && (safDestination = this.getSAFErrorHandlingDestination(jmsDescriptor = (IWebLogicJmsModuleDescriptor)descriptor, dest)) != null && !ObjectUtil.equal((Object)safDestination.getSubDeploymentName().text(), (Object)subdeploymentName)) {
                return Status.createErrorStatus((String)ValidatorResources.safDestinationSameSubdeployomentError);
            }
        }
        return Status.createOkStatus();
    }

    private ISAFImportedDestinations getSAFErrorHandlingDestination(IWebLogicJmsModuleDescriptor jmsDescriptor, String dest) {
        for (ISAFErrorHandling errorHandling : jmsDescriptor.getSafErrorHandlers()) {
            String destinationName;
            if (!dest.equals(errorHandling.getName().text()) || (destinationName = errorHandling.getSafErrorDestination().text()) == null) continue;
            for (ISAFImportedDestinations destination : jmsDescriptor.getSafImportedDestinations()) {
                for (ISAFQueue queue : destination.getSafQueues()) {
                    if (!destinationName.equals(queue.getName().text())) continue;
                    return destination;
                }
                for (ISAFTopic topic : destination.getSafTopics()) {
                    if (!destinationName.equals(topic.getName().text())) continue;
                    return destination;
                }
            }
        }
        return null;
    }
}

