/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.descriptors.jms.internal;

import oracle.eclipse.tools.weblogic.descriptors.IWebLogicJmsModuleDescriptor;
import oracle.eclipse.tools.weblogic.descriptors.jms.IDestinationBase;
import oracle.eclipse.tools.weblogic.descriptors.jms.IDistributedDestinationMember;
import oracle.eclipse.tools.weblogic.descriptors.jms.IDistributedQueue;
import oracle.eclipse.tools.weblogic.descriptors.jms.IDistributedQueueMember;
import oracle.eclipse.tools.weblogic.descriptors.jms.IDistributedTopic;
import oracle.eclipse.tools.weblogic.descriptors.jms.IDistributedTopicMember;
import oracle.eclipse.tools.weblogic.descriptors.jms.IQueueBase;
import oracle.eclipse.tools.weblogic.descriptors.jms.ITopicBase;
import oracle.eclipse.tools.weblogic.descriptors.jms.internal.ValidatorResources;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.ElementList;
import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.PropertyContentEvent;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.ValueProperty;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.services.ValidationService;

public class DistributedMemberValidator
extends ValidationService {
    private boolean isQueue = true;
    private Listener listener;

    protected void initValidationService() {
        this.isQueue = Boolean.parseBoolean(this.param("isQueue"));
        this.listener = new FilteredListener<PropertyContentEvent>(){

            protected void handleTypedEvent(PropertyContentEvent event) {
                DistributedMemberValidator.this.refresh();
            }
        };
        IWebLogicJmsModuleDescriptor descriptor = (IWebLogicJmsModuleDescriptor)this.context(IWebLogicJmsModuleDescriptor.class);
        if (this.isQueue) {
            descriptor.attach(this.listener, "/Queues[#type=IQueue]/UnitOfWorkHandlingPolicy");
            descriptor.attach(this.listener, "/Queues[#type=IDistributedQueue]/DistributedQueueMember/Name");
            IDistributedQueueMember queue = (IDistributedQueueMember)this.context(IDistributedQueueMember.class);
            queue.attach(this.listener, "Name");
        } else {
            descriptor.attach(this.listener, "/Topics[#type=ITopic]/UnitOfWorkHandlingPolicy");
            descriptor.attach(this.listener, "/Topics[#type=IDistributedTopic]/DistributedTopicMembers/Name");
            IDistributedTopicMember topic = (IDistributedTopicMember)this.context(IDistributedTopicMember.class);
            topic.attach(this.listener, "Name");
        }
    }

    public void dispose() {
        super.dispose();
        IWebLogicJmsModuleDescriptor descriptor = (IWebLogicJmsModuleDescriptor)this.context(IWebLogicJmsModuleDescriptor.class);
        if (this.isQueue) {
            descriptor.detach(this.listener, "/Queues[#type=IQueue]/UnitOfWorkHandlingPolicy");
            descriptor.detach(this.listener, "/Queues[#type=IDistributedQueue]/DistributedQueueMember/Name");
            IDistributedQueueMember queue = (IDistributedQueueMember)this.context(IDistributedQueueMember.class);
            if (queue != null && !queue.disposed()) {
                queue.detach(this.listener, "Name");
            }
        } else {
            descriptor.detach(this.listener, "/Topics[#type=ITopic]/UnitOfWorkHandlingPolicy");
            descriptor.detach(this.listener, "/Topics[#type=IDistributedTopic]/DistributedTopicMembers/Name");
            IDistributedTopicMember topic = (IDistributedTopicMember)this.context(IDistributedTopicMember.class);
            if (topic != null && !topic.disposed()) {
                topic.detach(this.listener, "Name");
            }
        }
    }

    protected Status compute() {
        block7: {
            Object[] params;
            IWebLogicJmsModuleDescriptor jmsDescriptor;
            String str;
            Value value;
            block8: {
                Element descriptor;
                value = (Value)this.context(Value.class);
                str = value.text();
                if (str == null || !((descriptor = value.root()) instanceof IWebLogicJmsModuleDescriptor)) break block7;
                jmsDescriptor = (IWebLogicJmsModuleDescriptor)descriptor;
                String uow = this.getUOW(jmsDescriptor, str);
                if (uow != null) {
                    Element modelElement = value.element();
                    ValueProperty property = value.definition();
                    ElementList list = (ElementList)modelElement.parent();
                    for (Element x : list) {
                        String otherUOW;
                        Value xval;
                        String otherMember;
                        if (x == modelElement || (otherMember = (xval = x.property(property)).text()) == null || otherMember.length() <= 0 || (otherUOW = this.getUOW(jmsDescriptor, otherMember)) == null || uow.equals(otherUOW)) continue;
                        return Status.createErrorStatus((String)ValidatorResources.bind((String)ValidatorResources.diffUnitOfWorkError, (Object)str, (Object)otherMember));
                    }
                }
                if (!this.isQueue) break block8;
                IDistributedQueue thisQueue = (IDistributedQueue)value.element().nearest(IDistributedQueue.class);
                if (thisQueue == null) break block7;
                for (IQueueBase queue : jmsDescriptor.getQueues()) {
                    IDistributedQueue distributedQueue;
                    if (!(queue instanceof IDistributedQueue) || (distributedQueue = (IDistributedQueue)queue) == thisQueue) continue;
                    for (IDistributedDestinationMember member : distributedQueue.getDistributedQueueMember()) {
                        if (!str.equals(member.getName().text())) continue;
                        params = new String[]{str, queue.getName().text(), thisQueue.getName().text()};
                        return Status.createErrorStatus((String)ValidatorResources.bind((String)ValidatorResources.weightedDistributedDestinationMemberError, (Object[])params));
                    }
                }
                break block7;
            }
            IDistributedTopic thisTopic = (IDistributedTopic)value.element().nearest(IDistributedTopic.class);
            if (thisTopic != null) {
                for (ITopicBase topic : jmsDescriptor.getTopics()) {
                    IDistributedTopic distributedTopic;
                    if (!(topic instanceof IDistributedTopic) || (distributedTopic = (IDistributedTopic)topic) == thisTopic) continue;
                    for (IDistributedDestinationMember member : distributedTopic.getDistributedTopicMembers()) {
                        if (!str.equals(member.getName().text())) continue;
                        params = new String[]{str, topic.getName().text(), thisTopic.getName().text()};
                        return Status.createErrorStatus((String)ValidatorResources.bind((String)ValidatorResources.weightedDistributedDestinationMemberError, (Object[])params));
                    }
                }
            }
        }
        return Status.createOkStatus();
    }

    private String getUOW(IWebLogicJmsModuleDescriptor jmsDescriptor, String name) {
        if (this.isQueue) {
            for (IQueueBase queue : jmsDescriptor.getQueues()) {
                if (!name.equals(queue.getName().text()) || !(queue instanceof IDestinationBase)) continue;
                return ((IDestinationBase)((Object)queue)).getUnitOfWorkHandlingPolicy().text();
            }
        } else {
            for (ITopicBase topic : jmsDescriptor.getTopics()) {
                if (!name.equals(topic.getName().text()) || !(topic instanceof IDestinationBase)) continue;
                return ((IDestinationBase)((Object)topic)).getUnitOfWorkHandlingPolicy().text();
            }
        }
        return null;
    }
}

