/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.descriptors.jms.internal;

import oracle.eclipse.tools.weblogic.descriptors.IWebLogicJmsModuleDescriptor;
import oracle.eclipse.tools.weblogic.descriptors.jms.IDestinationKey;
import oracle.eclipse.tools.weblogic.descriptors.jms.IDestinationKeyReference;
import oracle.eclipse.tools.weblogic.descriptors.jms.internal.ValidatorResources;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.ElementList;
import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.PropertyContentEvent;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.services.ValidationService;

public class DestinationKeyValidator
extends ValidationService {
    private Listener listener;

    protected void initValidationService() {
        super.initValidationService();
        this.listener = new FilteredListener<PropertyContentEvent>(){

            protected void handleTypedEvent(PropertyContentEvent event) {
                DestinationKeyValidator.this.refresh();
            }
        };
        IWebLogicJmsModuleDescriptor descriptor = (IWebLogicJmsModuleDescriptor)this.context(IWebLogicJmsModuleDescriptor.class);
        descriptor.attach(this.listener, "/DestinationKeys/Name");
    }

    public void dispose() {
        super.dispose();
        IWebLogicJmsModuleDescriptor descriptor = (IWebLogicJmsModuleDescriptor)this.context(IWebLogicJmsModuleDescriptor.class);
        descriptor.detach(this.listener, "/DestinationKeys/Name");
    }

    protected Status compute() {
        IDestinationKeyReference destinationKey;
        String keyText;
        Element descriptor;
        ElementList list = (ElementList)this.context(ElementList.of(IDestinationKeyReference.class));
        int size = list.size();
        if (size > 1 && !"JMSMessageID".equals(this.getDestinationProperty(descriptor = list.root(), keyText = (destinationKey = (IDestinationKeyReference)list.get(size - 1)).getName().text()))) {
            return Status.createErrorStatus((String)ValidatorResources.bind((String)ValidatorResources.destinationKeyError, (Object)keyText));
        }
        return Status.createOkStatus();
    }

    private String getDestinationProperty(Element descriptor, String destinationKey) {
        if (destinationKey != null && destinationKey.length() > 0 && descriptor instanceof IWebLogicJmsModuleDescriptor) {
            IWebLogicJmsModuleDescriptor jmsDescriptor = (IWebLogicJmsModuleDescriptor)descriptor;
            for (IDestinationKey key : jmsDescriptor.getDestinationKeys()) {
                String name = key.getName().text();
                if (!destinationKey.equals(name)) continue;
                return key.getSortKey().text();
            }
        }
        return null;
    }
}

