/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.descriptors.jms.internal;

import oracle.eclipse.tools.weblogic.descriptors.jms.IDestinationKey;
import oracle.eclipse.tools.weblogic.descriptors.jms.internal.ValidatorResources;
import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.PropertyContentEvent;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.services.ValidationService;

public class DestinationKeyTypeValidator
extends ValidationService {
    private static final String[][] SORT_KEY_TYPE = new String[][]{{"JMSPriority", "Int"}};
    private Listener listener;

    protected void initValidationService() {
        super.initValidationService();
        this.listener = new FilteredListener<PropertyContentEvent>(){

            protected void handleTypedEvent(PropertyContentEvent event) {
                DestinationKeyTypeValidator.this.refresh();
            }
        };
        ((IDestinationKey)this.context(IDestinationKey.class)).getSortKey().attach(this.listener);
    }

    public void dispose() {
        super.dispose();
        IDestinationKey destinationKey = (IDestinationKey)this.context(IDestinationKey.class);
        if (destinationKey != null && !destinationKey.disposed()) {
            destinationKey.getSortKey().detach(this.listener);
        }
    }

    protected Status compute() {
        Value value = (Value)this.context(Value.class);
        String str = value.text();
        IDestinationKey destinationKey = (IDestinationKey)value.element().nearest(IDestinationKey.class);
        String sortKey = destinationKey.getSortKey().text();
        int i = 0;
        while (i < SORT_KEY_TYPE.length) {
            String key = SORT_KEY_TYPE[i][0];
            String type = SORT_KEY_TYPE[i][1];
            if (key.equals(sortKey) && !type.equals(str)) {
                return Status.createErrorStatus((String)ValidatorResources.bind((String)ValidatorResources.destinationKeyTypeError, (Object)type, (Object)key));
            }
            ++i;
        }
        return Status.createOkStatus();
    }
}

