/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.descriptors.jms;

import oracle.eclipse.tools.weblogic.descriptors.jms.ForwardingPolicy;
import oracle.eclipse.tools.weblogic.descriptors.jms.IMulticastParams;
import oracle.eclipse.tools.weblogic.descriptors.jms.ITopicBase;
import oracle.eclipse.tools.weblogic.descriptors.jms.IUniformDistributedDestination;
import org.eclipse.sapphire.ElementType;
import org.eclipse.sapphire.ImpliedElementProperty;
import org.eclipse.sapphire.Since;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.ValueProperty;
import org.eclipse.sapphire.modeling.annotations.DefaultValue;
import org.eclipse.sapphire.modeling.annotations.Documentation;
import org.eclipse.sapphire.modeling.annotations.Image;
import org.eclipse.sapphire.modeling.annotations.Label;
import org.eclipse.sapphire.modeling.annotations.Type;
import org.eclipse.sapphire.modeling.xml.annotations.XmlBinding;

@Label(standard="uniform distributed topic")
@Image(path="images/descriptors/jms/queue-distributed.png")
public interface IUniformDistributedTopic
extends ITopicBase,
IUniformDistributedDestination {
    public static final ElementType TYPE = new ElementType(IUniformDistributedTopic.class);
    @Type(base=IMulticastParams.class)
    @XmlBinding(path="")
    public static final ImpliedElementProperty PROP_MULTICAST_PARAMS = new ImpliedElementProperty(TYPE, "MulticastParams");
    @Type(base=ForwardingPolicy.class)
    @Label(standard="forwarding policy")
    @XmlBinding(path="forwarding-policy")
    @Since(value="10.3.4")
    @DefaultValue(text="Replicated")
    @Documentation(content="The uniform distributed topic message Forwarding Policy specifies whether a sent message is forwarded to all members. The valid values are:[ul][li]Replicated: The default. All physical topic members receive each sent message. If a message arrives at one of the physical topic members, a copy of this message is forwarded to the other members of that uniform distributed topic. A subscription on any one particular member will get a copy of any message sent to the uniform distributed topic logical name or to any particular uniform distributed topic member.[/li][li]Partitioned: The physical member receiving the message is the only member of the uniform distributed topic that is aware of the message. When a message is published to the logical name of a Partitioned uniform distributed topic, it will only arrive on one particular physical topic member. Once a message arrives on a physical topic member, the message is not forwarded to the rest of the members of the uniform distributed destination, and subscribers on other physical topic members do not get a copy of that message. The Partitioned capability was added in WebLogic Server 11gR1 (10.3.4).[/li][/ul][br/]Most new applications will use the new Partitioned forwarding policy in combination with a \u2018logical subscription topology\u2019 on a uniform distributed topic that consists of (1) a same named physical subscription created directly on each physical member, (2) a Client ID Policy of Unrestricted, and (3) a Subscription Sharing Policy of Sharable. WL 10.3.4 Message Driven Beans (MDBs) provides a Topic Messages Distribution Mode option to automatically setup this kind of topology.")
    public static final ValueProperty PROP_FORWARDING_POLICY = new ValueProperty(TYPE, "ForwardingPolicy");

    public IMulticastParams getMulticastParams();

    public Value<ForwardingPolicy> getForwardingPolicy();

    public void setForwardingPolicy(String var1);

    public void setForwardingPolicy(ForwardingPolicy var1);
}

