/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.descriptors.jms;

import oracle.eclipse.tools.weblogic.descriptors.jms.IMessageLoggingFormatPart;
import oracle.eclipse.tools.weblogic.descriptors.jms.INamedEntity;
import oracle.eclipse.tools.weblogic.descriptors.jms.SAFErrorHandlingPolicy;
import oracle.eclipse.tools.weblogic.descriptors.jms.internal.SAFErrorDestinationValuesProvider;
import oracle.eclipse.tools.weblogic.descriptors.jms.internal.SAFErrorHandlingLoggingFormatBinding;
import org.eclipse.sapphire.ElementList;
import org.eclipse.sapphire.ElementType;
import org.eclipse.sapphire.ListProperty;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.ValueProperty;
import org.eclipse.sapphire.modeling.annotations.DefaultValue;
import org.eclipse.sapphire.modeling.annotations.Documentation;
import org.eclipse.sapphire.modeling.annotations.Label;
import org.eclipse.sapphire.modeling.annotations.NoDuplicates;
import org.eclipse.sapphire.modeling.annotations.Service;
import org.eclipse.sapphire.modeling.annotations.Type;
import org.eclipse.sapphire.modeling.xml.annotations.CustomXmlListBinding;
import org.eclipse.sapphire.modeling.xml.annotations.XmlBinding;

@Label(standard="SAF error handler")
public interface ISAFErrorHandling
extends INamedEntity {
    public static final ElementType TYPE = new ElementType(ISAFErrorHandling.class);
    @Type(base=SAFErrorHandlingPolicy.class)
    @XmlBinding(path="policy")
    @Label(standard="message handling policy")
    @DefaultValue(text="Discard")
    @Documentation(content="The error handling policy for this SAF error handling resource.[ul][li]Discard: By default, expired messages are simply removed from the system. The removal is not logged and the message is not redirected to another location.[/li][li]Log: Removes expired messages and writes an entry to the server log file indicating that the messages were removed from the system. You define the actual information that will be logged in the Log Format field.[/li][li]Redirect: Moves expired messages from their current location into the Error Destination defined for imported SAF destinations.[/li][li]Always-Forward: Ignores the SAF Default Time-to-Live value set on the imported destination and the expiration time set on the message, and so forwards the message to a remote destination even after it has expired.[/li][/ul]")
    public static final ValueProperty PROP_SAF_ERROR_HANDLING_POLICY = new ValueProperty(TYPE, "SafErrorHandlingPolicy");
    @Label(standard="log format")
    @Type(base=IMessageLoggingFormatPart.class)
    @CustomXmlListBinding(impl=SAFErrorHandlingLoggingFormatBinding.class)
    @NoDuplicates
    @Documentation(content="Specifies how information is logged when Policy is set to Log.")
    public static final ListProperty PROP_LOG_FORMAT = new ListProperty(TYPE, "LogFormat");
    @XmlBinding(path="saf-error-destination")
    @Label(standard="error destination")
    @Service(impl=SAFErrorDestinationValuesProvider.class)
    @Documentation(content="Specifies the error destination when Policy is set to Redirect.")
    public static final ValueProperty PROP_SAF_ERROR_DESTINATION = new ValueProperty(TYPE, "SafErrorDestination");

    public Value<SAFErrorHandlingPolicy> getSafErrorHandlingPolicy();

    public void setSafErrorHandlingPolicy(String var1);

    public void setSafErrorHandlingPolicy(SAFErrorHandlingPolicy var1);

    public ElementList<IMessageLoggingFormatPart> getLogFormat();

    public Value<String> getSafErrorDestination();

    public void setSafErrorDestination(String var1);
}

