/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.descriptors.jms;

import oracle.eclipse.tools.weblogic.descriptors.jms.internal.IPAddressValidationService;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.ElementType;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.ValueProperty;
import org.eclipse.sapphire.modeling.annotations.Documentation;
import org.eclipse.sapphire.modeling.annotations.Label;
import org.eclipse.sapphire.modeling.annotations.NumericRange;
import org.eclipse.sapphire.modeling.annotations.Service;
import org.eclipse.sapphire.modeling.annotations.Type;
import org.eclipse.sapphire.modeling.xml.annotations.XmlBinding;

public interface IMulticastParamsBase
extends Element {
    public static final ElementType TYPE = new ElementType(IMulticastParamsBase.class);
    @XmlBinding(path="multicast/multicast-address")
    @Label(standard="address", full="multicast address")
    @Service(impl=IPAddressValidationService.class)
    @Documentation(content="The IP address that this topic uses to transmit messages to multicast consumers.")
    public static final ValueProperty PROP_ADDRESS = new ValueProperty(TYPE, "Address");
    @Type(base=Integer.class)
    @XmlBinding(path="multicast/multicast-port")
    @Label(standard="port", full="multicast port")
    @NumericRange(min="1", max="65535")
    @Documentation(content="The IP port that this topic uses to transmit messages to multicast consumers.")
    public static final ValueProperty PROP_PORT = new ValueProperty(TYPE, "Port");
    @Type(base=Integer.class)
    @XmlBinding(path="multicast/multicast-time-to-live")
    @Label(standard="time to live", full="multicast time to live")
    @NumericRange(min="0", max="255")
    @Documentation(content="The number of routers that a message can traverse enroute to the consumers. A value of 1 limits the message to one subnet (which prevents it from traversing any routers).")
    public static final ValueProperty PROP_TIME_TO_LIVE = new ValueProperty(TYPE, "TimeToLive");

    public Value<String> getAddress();

    public void setAddress(String var1);

    public Value<Integer> getPort();

    public void setPort(String var1);

    public void setPort(Integer var1);

    public Value<Integer> getTimeToLive();

    public void setTimeToLive(String var1);

    public void setTimeToLive(Integer var1);
}

