/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.descriptors.jms;

import oracle.eclipse.tools.weblogic.descriptors.jms.IForeignConnectionFactory;
import oracle.eclipse.tools.weblogic.descriptors.jms.IForeignJndiObject;
import oracle.eclipse.tools.weblogic.descriptors.jms.INamedEntity;
import oracle.eclipse.tools.weblogic.descriptors.jms.IPropertyType;
import oracle.eclipse.tools.weblogic.descriptors.jms.ITargetable;
import oracle.eclipse.tools.weblogic.descriptors.jms.internal.JndiPropertiesCredentialBinding;
import org.eclipse.sapphire.ElementList;
import org.eclipse.sapphire.ElementType;
import org.eclipse.sapphire.ListProperty;
import org.eclipse.sapphire.ReferenceValue;
import org.eclipse.sapphire.Since;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.ValueProperty;
import org.eclipse.sapphire.java.JavaType;
import org.eclipse.sapphire.java.JavaTypeConstraint;
import org.eclipse.sapphire.java.JavaTypeKind;
import org.eclipse.sapphire.java.JavaTypeName;
import org.eclipse.sapphire.modeling.annotations.DefaultValue;
import org.eclipse.sapphire.modeling.annotations.Documentation;
import org.eclipse.sapphire.modeling.annotations.Label;
import org.eclipse.sapphire.modeling.annotations.MustExist;
import org.eclipse.sapphire.modeling.annotations.Reference;
import org.eclipse.sapphire.modeling.annotations.SensitiveData;
import org.eclipse.sapphire.modeling.annotations.Type;
import org.eclipse.sapphire.modeling.xml.annotations.CustomXmlValueBinding;
import org.eclipse.sapphire.modeling.xml.annotations.XmlBinding;
import org.eclipse.sapphire.modeling.xml.annotations.XmlListBinding;

@Label(standard="foreign server")
public interface IForeignServer
extends ITargetable,
INamedEntity {
    public static final ElementType TYPE = new ElementType(IForeignServer.class);
    @Type(base=JavaTypeName.class)
    @Reference(target=JavaType.class)
    @XmlBinding(path="initial-context-factory")
    @Label(standard="initial context factory")
    @DefaultValue(text="weblogic.jndi.WLInitialContextFactory")
    @JavaTypeConstraint(kind={JavaTypeKind.CLASS}, type={"javax.naming.spi.InitialContextFactory"})
    @MustExist
    @Documentation(content="The name of the class that must be instantiated to access the JNDI provider.")
    public static final ValueProperty PROP_INITIAL_CONTEXT_FACTORY = new ValueProperty(TYPE, "InitialContextFactory");
    @XmlBinding(path="connection-url")
    @Label(standard="connection URL")
    @Documentation(content="The URL that Oracle WebLogic Server will use to contact the JNDI provider.[pbr/]Do not specify a URL if the remote resource runs in the same cluster or server.")
    public static final ValueProperty PROP_CONNECTION_URL = new ValueProperty(TYPE, "ConnectionUrl");
    @Label(standard="JNDI properties credential")
    @CustomXmlValueBinding(impl=JndiPropertiesCredentialBinding.class)
    @SensitiveData
    @Since(value="10.0")
    @Documentation(content="A credential (password) must normally be specified if a principal is included in the JNDI properties.")
    public static final ValueProperty PROP_JNDI_PROPERTIES_CREDENTIAL = new ValueProperty(TYPE, "JndiPropertiesCredential");
    @XmlBinding(path="jndi-properties-credential-encrypted")
    @Label(standard="JNDI properties credential")
    @SensitiveData
    @Documentation(content="Any Credentials that must be set for the JNDI provider. These Credentials will be part of the properties that will be passed directly to the constructor for the JNDI provider's InitialContext class.")
    public static final ValueProperty PROP_JNDI_PROPERTIES_CREDENTIAL_ENCRYPTED = new ValueProperty(TYPE, "JndiPropertiesCredentialEncrypted");
    @Type(base=IPropertyType.class)
    @Label(standard="JNDI properties")
    @XmlListBinding(mappings={@XmlListBinding.Mapping(element="jndi-property", type=IPropertyType.class)})
    @Documentation(content="Any additional properties that must be set for the JNDI provider. These properties will be passed directly to the constructor for the JNDI provider's InitialContext class.[pbr/]The most commonly specified JNDI property key is \"java.naming.security.principal\" (the username).")
    public static final ListProperty PROP_JNDI_PROPERTIES = new ListProperty(TYPE, "JndiProperties");
    @Type(base=IForeignJndiObject.class)
    @Label(standard="foreign destinations")
    @XmlListBinding(mappings={@XmlListBinding.Mapping(element="foreign-destination", type=IForeignJndiObject.class)})
    @Documentation(content="Defines an array of all foreign destinations associated with this foreign server.")
    public static final ListProperty PROP_FOREIGN_DESTINATIONS = new ListProperty(TYPE, "ForeignDestinations");
    @Type(base=IForeignConnectionFactory.class)
    @Label(standard="foreign connection factories")
    @XmlListBinding(mappings={@XmlListBinding.Mapping(element="foreign-connection-factory", type=IForeignConnectionFactory.class)})
    @Documentation(content="Defines an array of all foreign connection factories associated with this foreign server.")
    public static final ListProperty PROP_FOREIGN_CONNECTION_FACTORIES = new ListProperty(TYPE, "ForeignConnectionFactories");

    public ReferenceValue<JavaTypeName, JavaType> getInitialContextFactory();

    public void setInitialContextFactory(String var1);

    public void setInitialContextFactory(JavaTypeName var1);

    public Value<String> getConnectionUrl();

    public void setConnectionUrl(String var1);

    public Value<String> getJndiPropertiesCredential();

    public void setJndiPropertiesCredential(String var1);

    public Value<String> getJndiPropertiesCredentialEncrypted();

    public void setJndiPropertiesCredentialEncrypted(String var1);

    public ElementList<IPropertyType> getJndiProperties();

    public ElementList<IForeignJndiObject> getForeignDestinations();

    public ElementList<IForeignConnectionFactory> getForeignConnectionFactories();
}

