/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.descriptors.jms;

import oracle.eclipse.tools.weblogic.descriptors.jms.DeliveryMode;
import oracle.eclipse.tools.weblogic.descriptors.jms.internal.DeliveryModeBinding;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.ElementType;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.ValueProperty;
import org.eclipse.sapphire.modeling.annotations.Documentation;
import org.eclipse.sapphire.modeling.annotations.Label;
import org.eclipse.sapphire.modeling.annotations.NamedValues;
import org.eclipse.sapphire.modeling.annotations.NumericRange;
import org.eclipse.sapphire.modeling.annotations.Type;
import org.eclipse.sapphire.modeling.xml.annotations.CustomXmlValueBinding;
import org.eclipse.sapphire.modeling.xml.annotations.XmlBinding;

public interface IDeliveryParamsOverridesBase
extends Element {
    public static final ElementType TYPE = new ElementType(IDeliveryParamsOverridesBase.class);
    @Type(base=DeliveryMode.class)
    @CustomXmlValueBinding(impl=DeliveryModeBinding.class)
    @Label(standard="delivery mode")
    @Documentation(content="The delivery mode assigned to all messages that arrive at the destination regardless of the DeliveryMode specified by the message producer.")
    public static final ValueProperty PROP_DELIVERY_MODE = new ValueProperty(TYPE, "DeliveryMode");
    @NamedValues(arbitraryValueLabel="time to deliver (msec or schedule)", defaultArbitraryValue="0", namedValues={@NamedValues.NamedValue(value="-1", label="destination will not override message producer")})
    @XmlBinding(path="delivery-params-overrides/time-to-deliver")
    @Label(standard="time to deliver")
    @Documentation(content="The default delay, either in milliseconds or as a schedule, between when a message is produced and when it is made visible on its target destination, regardless of the delivery time specified by the producer and/or connection factory. The default value (-1) specifies that the destination will not override the TimeToDeliver setting specified by the producer and/or connection factory. The TimeToDeliver override can be specified either as a long or as a schedule.")
    public static final ValueProperty PROP_TIME_TO_DELIVER = new ValueProperty(TYPE, "TimeToDeliver");
    @NamedValues(arbitraryValueLabel="time to live (msec)", defaultArbitraryValue="0", namedValues={@NamedValues.NamedValue(value="-1", label="destination will not override message producer")})
    @Type(base=Long.class)
    @XmlBinding(path="delivery-params-overrides/time-to-live")
    @Label(standard="time to live")
    @NumericRange(min="-1")
    @Documentation(content="The time-to-live assigned to all messages that arrive at this destination, regardless of the TimeToLive value specified by the message producer. The default value (-1) specifies that this setting will not override the TimeToLive setting specified by the message producer.")
    public static final ValueProperty PROP_TIME_TO_LIVE = new ValueProperty(TYPE, "TimeToLive");
    @NamedValues(arbitraryValueLabel="priority", defaultArbitraryValue="4", namedValues={@NamedValues.NamedValue(value="-1", label="destination will not override message producer")})
    @Type(base=Integer.class)
    @XmlBinding(path="delivery-params-overrides/priority")
    @Label(standard="priority")
    @NumericRange(min="-1", max="9")
    @Documentation(content="The priority assigned to all messages that arrive at this destination, regardless of the Priority specified by the message producer. The default value (-1) specifies that the destination will not override the Priority set by the message producer.")
    public static final ValueProperty PROP_PRIORITY = new ValueProperty(TYPE, "Priority");
    @NamedValues(arbitraryValueLabel="redelivery delay (msecs)", defaultArbitraryValue="0", namedValues={@NamedValues.NamedValue(value="-1", label="destination will not override message producer")})
    @Type(base=Long.class)
    @XmlBinding(path="delivery-params-overrides/redelivery-delay")
    @Label(standard="redelivery delay (msecs)")
    @NumericRange(min="-1")
    @Documentation(content="The delay, in milliseconds, before rolled back or recovered messages are redelivered, regardless of the RedeliveryDelay specified by the consumer and/or connection factory. Redelivered queue messages are put back into their originating destination; redelivered topic messages are put back into their originating subscription. The default value (-1) specifies that the destination will not override the RedeliveryDelay setting specified by the consumer and/or connection factory.")
    public static final ValueProperty PROP_REDELIVERY_DELAY = new ValueProperty(TYPE, "RedeliveryDelay");

    public Value<DeliveryMode> getDeliveryMode();

    public void setDeliveryMode(String var1);

    public void setDeliveryMode(DeliveryMode var1);

    public Value<String> getTimeToDeliver();

    public void setTimeToDeliver(String var1);

    public Value<Long> getTimeToLive();

    public void setTimeToLive(String var1);

    public void setTimeToLive(Long var1);

    public Value<Integer> getPriority();

    public void setPriority(String var1);

    public void setPriority(Integer var1);

    public Value<Long> getRedeliveryDelay();

    public void setRedeliveryDelay(String var1);

    public void setRedeliveryDelay(Long var1);
}

