/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.descriptors.jms;

import oracle.eclipse.tools.weblogic.descriptors.jms.AcknowledgePolicy;
import oracle.eclipse.tools.weblogic.descriptors.jms.ClientIdPolicy;
import oracle.eclipse.tools.weblogic.descriptors.jms.MulticastOverrunPolicy;
import oracle.eclipse.tools.weblogic.descriptors.jms.ReconnectPolicy;
import oracle.eclipse.tools.weblogic.descriptors.jms.SubscriptionSharingPolicy;
import oracle.eclipse.tools.weblogic.descriptors.jms.SynchronousPrefetchMode;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.ElementType;
import org.eclipse.sapphire.Since;
import org.eclipse.sapphire.Validation;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.ValueProperty;
import org.eclipse.sapphire.modeling.annotations.DefaultValue;
import org.eclipse.sapphire.modeling.annotations.Documentation;
import org.eclipse.sapphire.modeling.annotations.Enablement;
import org.eclipse.sapphire.modeling.annotations.Fact;
import org.eclipse.sapphire.modeling.annotations.Label;
import org.eclipse.sapphire.modeling.annotations.NamedValues;
import org.eclipse.sapphire.modeling.annotations.NumericRange;
import org.eclipse.sapphire.modeling.annotations.Type;
import org.eclipse.sapphire.modeling.xml.annotations.XmlBinding;

public interface IClientParams
extends Element {
    public static final ElementType TYPE = new ElementType(IClientParams.class);
    @XmlBinding(path="client-params/client-id")
    @Label(standard="client ID")
    @Documentation(content="An optional Client ID for applications that use this JMS connection factory. If the Client ID Policy (feature of WebLogic Server 11gR1 (10.3.4) or newer) is set to Restricted (the default), then configuring a Client ID on the connection factory prevents more than one JMS client from using a connection from this factory. This attribute is rarely configured and should normally be left at the default (not set), as JMS application programs can set their Client IDs dynamically using the standard JMS API javax.jms.Connection.setClientID(), and JMS application message processing containers (such as MDBs) normally make the Client ID configurable as part of container configuration.")
    public static final ValueProperty PROP_CLIENT_ID = new ValueProperty(TYPE, "ClientId");
    @Type(base=ClientIdPolicy.class)
    @Label(standard="client ID policy")
    @XmlBinding(path="client-params/client-id-policy")
    @Since(value="10.3.4")
    @DefaultValue(text="Restricted")
    @Documentation(content="The Client ID Policy indicates whether more than one JMS connection can use the same Client ID. The valid values are:[pbr/]* Restricted: The default. Only one connection that uses this policy can exist in a cluster at any given time for a particular Client ID (if a connection already exists with a given Client ID, attempts to create new connections with the same Client ID will fail with an exception).[pbr/]* Unrestricted: Connections created using this policy can specify any Client ID, even when other restricted or unrestricted connections already use the same Client ID.  The Unrestricted Client ID capability was added in WebLogic Server 11gR1 (10.3.4).[pbr/]Notes:[pbr/]* WebLogic JMS applications can override the Client ID Policy specified on the connection factory configuration by casting a javax.jms.Connection instance to  weblogic.jms.extension.WLConnection and calling setClientID(String clientID, String clientIDPolicy) or setClientIDPolicy(String clientIDPolicy).[pbr/]* Two connections with the same Client ID are treated as two different independent connections if they have different Client ID Policy. This means a cluster can host a single Restricted Client ID Policy connection, and also concurrently host multiple Unrestricted Client ID Policy connections that have the same Client ID as the Restricted connection.[pbr/]* Two durable subscriptions with the same Client ID and Subscription Name are treated as two different independent subscriptions if they have a different Client ID Policy. Similarly, two Sharable non-durable subscriptions with the same client-id are treated as two different independent subscriptions if they have a different Client ID Policy.")
    public static final ValueProperty PROP_CLIENT_ID_POLICY = new ValueProperty(TYPE, "ClientIdPolicy");
    @Type(base=SubscriptionSharingPolicy.class)
    @Label(standard="subscription sharing policy")
    @XmlBinding(path="client-params/subscription-sharing-policy")
    @Since(value="10.3.4")
    @DefaultValue(text="Exclusive")
    @Documentation(content="Specifies the subscription sharing policy on this connection. Although this attribute is dynamic, the new values only take effect on future connections and have no impact to existing connections created before the value was changed. The valid values are:[ul][li]Exclusive: The default. All subscribers created using this connection factory cannot share subscriptions with any other subscribers.[/li][li]Sharable: Subscribers created using this connection factory can share their subscriptions with other subscribers, regardless of whether those subscribers are created using the same connection factory or a different connection factory. Consumers can share a non-durable subscriptions only if they have the same Client ID and Client ID Policy; consumers can share a durable subscription only if they have the same Client ID, Client ID Policy, and Subscription Name. The Sharable Subscription Sharing capability was added in WebLogic Server 11gR1 (10.3.4).[/li][/ul][pbr/]Notes: [pbr/]* WebLogic JMS applications can override the Subscription Sharing Policy specified on the connection factory configuration by casting a javax.jms.Connection instance to weblogic.jms.extension.WLConnection and calling setSubscriptionSharingPolicy(String).[pbr/]* Most applications with a Sharable Subscription Sharing Policy will also use an Unrestricted Client ID Policy in order to ensure that multiple connections with the same client ID can exist.[pbr/]* Two durable subscriptions with the same Client ID and Subscription Name are treated as two different independent subscriptions if they have a different Client ID Policy. Similarly, two Sharable non-durable subscriptions with the same Client ID are treated as two different independent subscriptions if they have a different Client ID Policy.[pbr/]* Sharable subscriptions are not part of the standard JMS 1.1 specification, but most major JMS vendors support some form of sharable subscriptions.")
    public static final ValueProperty PROP_SUBSCRIPTION_SHARING_POLICY = new ValueProperty(TYPE, "SubscriptionSharingPolicy");
    @Type(base=AcknowledgePolicy.class)
    @XmlBinding(path="client-params/acknowledge-policy")
    @Label(standard="client acknowledge policy")
    @DefaultValue(text="All")
    @Documentation(content="Acknowledge policy for non-transacted sessions that use the CLIENT_ACKNOWLEDGE mode. All indicates that calling acknowledge on a message acknowledges all unacknowledged messages received on the session. Previous specifies that calling acknowledge on a message acknowledges only unacknowledged messages up to, and including, the given message.")
    public static final ValueProperty PROP_ACKNOWLEDGE_POLICY = new ValueProperty(TYPE, "AcknowledgePolicy");
    @Type(base=Boolean.class)
    @XmlBinding(path="client-params/allow-close-in-onMessage")
    @Label(standard="allow Close() within onMessage()")
    @DefaultValue(text="true")
    @Documentation(content="Specifies whether or not the connection factory creates message consumers that allow a close() method to be issued within its onMessage() method call.")
    public static final ValueProperty PROP_ALLOW_CLOSE = new ValueProperty(TYPE, "AllowClose");
    @Type(base=Integer.class)
    @XmlBinding(path="client-params/messages-maximum")
    @Label(standard="maximum pipelined messages per session")
    @DefaultValue(text="10")
    @Validation(rule="${ MessagesMaximum == -1 || MessagesMaximum > 0 }", message="Must be a non-zero positive integer or -1.")
    @Fact(statement="Must be a non-zero positive integer or -1.")
    @Documentation(content="The maximum number of messages that can exist for an asynchronous session and that have not yet been passed to the message listener. When the Synchronous Prefetch Mode is enabled, this value also affects synchronous sessions with a message consumer that will prefetch messages in one server access.[pbr/]A value of -1 indicates that there is no limit on the number of messages. In this case, however, the limit is set to the amount of remaining virtual memory.[pbr/]When the number of messages reaches the MessagesMaximum value:[pbr/]* For multicast sessions, new messages are discarded according the policy specified by the OverrunPolicy parameter and a DataOverrunException is thrown.[pbr/]* For non-multicast sessions, new messages are flow-controlled, or retained on the server until the application can accommodate the messages.[pbr/]For multicast sessions, when a connection is stopped, messages will continue to be delivered, but only until the MessagesMaximum value is reached. Once this value is reached, messages will be discarded based on the OverrunPolicy setting. ")
    public static final ValueProperty PROP_MESSAGES_MAXIMUM = new ValueProperty(TYPE, "MessagesMaximum");
    @Type(base=MulticastOverrunPolicy.class)
    @XmlBinding(path="client-params/multicast-overrun-policy")
    @Label(standard="multicast overrun policy")
    @DefaultValue(text="KeepOld")
    @Documentation(content="The policy to use when the number of outstanding multicast messages reaches the value specified in MessagesMaximum and some messages must be discarded.[ul][li]Keep New: Indicates that the most recent messages are given priority over the oldest messages, and the oldest messages are discarded, as needed.[/li][li]Keep Old: Indicates that the oldest messages are given priority over the most recent messages, and the most recent messages are discarded, as needed.[/li][/ul][br/]Message age is defined by the order of receipt, not by the JMSTimestamp value.")
    public static final ValueProperty PROP_OVERRUN_POLICY = new ValueProperty(TYPE, "OverrunPolicy");
    @Type(base=SynchronousPrefetchMode.class)
    @XmlBinding(path="client-params/synchronous-prefetch-mode")
    @Label(standard="prefetch mode for synchronous consumer")
    @DefaultValue(text="disabled")
    @Documentation(content="Specifies whether or not a synchronous consumer will prefetch messages (that is, messages sent from the server to the client) in one server access.[ul][li]Disabled: Indicates that message prefetching is disabled.[/li][li]Enabled: Indicates that a synchronous consumer (queue receiver or topic subscriber) will prefetch messages. The amount of prefetched messages cannot exceed the maximum number of messages defined by the Messages Maximum parameter.[/li][li]Topic Subscriber Only: Indicates that only a synchronous topic subscriber will prefetch messages. The amount of prefetched messages cannot exceed the maximum number of messages defined by the Messages Maximum parameter.[/li][/ul][br/]Synchronous message prefetching does not support the following conditions, and will throw a JMS Exception when encountered:[pbr/] * User (XA) transactions for synchronous message receives[br/] * Multiple synchronous consumers per session (regardless of queue or topic)")
    public static final ValueProperty PROP_SYNCHRONOUS_PREFETCH_MODE = new ValueProperty(TYPE, "SynchronousPrefetchMode");
    @Type(base=ReconnectPolicy.class)
    @XmlBinding(path="client-params/reconnect-policy")
    @Label(standard="reconnect policy")
    @DefaultValue(text="producer")
    @Documentation(content="Specifies which types of JMS clients will be explicitly and implicitly refreshed after a lost network connection with a server or upon a server reboot. For example, selecting the Producers option will explicitly refresh JMS Producers and implicitly refresh any related Session and Connection clients.[ul][li]None: Do not refresh any JMS clients derived from this connection factory.[/li][li]Producers: Refresh all JMS Producer clients derived from this connection factory. This option does not refresh Consumers, QueueBrowsers, or Connections with a configured Client ID for a durable subscriber.[/li][li]All: Refresh all JMS Consumer and Producer clients derived from this connection factory, including Connections with a configured Client ID for a durable subscriber. This option does not refresh QueueBrowser clients.[/li][/ul]")
    public static final ValueProperty PROP_RECONNECT_POLICY = new ValueProperty(TYPE, "ReconnectPolicy");
    @NamedValues(arbitraryValueLabel="reconnect blocking time (msecs)", defaultArbitraryValue="60000", namedValues={@NamedValues.NamedValue(value="0", label="do not wait for any reconnect in progress"), @NamedValues.NamedValue(value="-1", label="wait for a reconnect indefinitely")})
    @Type(base=Long.class)
    @XmlBinding(path="client-params/reconnect-blocking-millis")
    @Label(standard="reconnect blocking time")
    @NumericRange(min="-1")
    @DefaultValue(text="60000")
    @Enablement(expr="${ ReconnectPolicy == 'producer' || ReconnectPolicy == 'all' }")
    @Documentation(content="The maximum length of time, in milliseconds, that any synchronous JMS calls, such as a producer.send(), consumer.receive(), or session.createBrowser(), will block the calling thread before giving up on a JMS client reconnect in progress.[pbr/]This attribute is effective only if the ReconnectPolicy option is set to either Producers or All. A value of 0 will cause synchronous JMS calls to not wait for any reconnect in progress; a value of -1 will cause an infinite wait for a reconnect.")
    public static final ValueProperty PROP_RECONNECT_BLOCKING_TIME = new ValueProperty(TYPE, "ReconnectBlockingTime");
    @NamedValues(arbitraryValueLabel="reconnect period (msecs)", defaultArbitraryValue="60000", namedValues={@NamedValues.NamedValue(value="0", label="exactly one retry attempt"), @NamedValues.NamedValue(value="-1", label="keep trying to reconnect indefinitely")})
    @Type(base=Long.class)
    @XmlBinding(path="client-params/total-reconnect-period-millis")
    @Label(standard="total reconnect period")
    @NumericRange(min="-1")
    @DefaultValue(text="-1")
    @Enablement(expr="${ ReconnectPolicy == 'producer' || ReconnectPolicy == 'all' }")
    @Documentation(content="The maximum length of time, in milliseconds, that JMS clients (particularly asynchronous consumers) will continue to try to reconnect to the server after either the initial network disconnect or the last synchronous call attempt, whichever occurred most recently, before giving up retrying.[pbr/]This attribute is effective only if the ReconnectPolicy attribute is set to either Producers or All. The default value of -1 means that that it will keep trying to reconnect indefinitely; a value of 0 means that there would be exactly one retry attempt.")
    public static final ValueProperty PROP_RECONNECT_PERIOD = new ValueProperty(TYPE, "ReconnectPeriod");

    public Value<String> getClientId();

    public void setClientId(String var1);

    public Value<ClientIdPolicy> getClientIdPolicy();

    public void setClientIdPolicy(String var1);

    public void setClientIdPolicy(ClientIdPolicy var1);

    public Value<SubscriptionSharingPolicy> getSubscriptionSharingPolicy();

    public void setSubscriptionSharingPolicy(String var1);

    public void setSubscriptionSharingPolicy(SubscriptionSharingPolicy var1);

    public Value<AcknowledgePolicy> getAcknowledgePolicy();

    public void setAcknowledgePolicy(String var1);

    public void setAcknowledgePolicy(AcknowledgePolicy var1);

    public Value<Boolean> getAllowClose();

    public void setAllowClose(String var1);

    public void setAllowClose(Boolean var1);

    public Value<Integer> getMessagesMaximum();

    public void setMessagesMaximum(String var1);

    public void setMessagesMaximum(Integer var1);

    public Value<MulticastOverrunPolicy> getOverrunPolicy();

    public void setOverrunPolicy(String var1);

    public void setOverrunPolicy(MulticastOverrunPolicy var1);

    public Value<SynchronousPrefetchMode> getSynchronousPrefetchMode();

    public void setSynchronousPrefetchMode(String var1);

    public void setSynchronousPrefetchMode(SynchronousPrefetchMode var1);

    public Value<ReconnectPolicy> getReconnectPolicy();

    public void setReconnectPolicy(String var1);

    public void setReconnectPolicy(ReconnectPolicy var1);

    public Value<Long> getReconnectBlockingTime();

    public void setReconnectBlockingTime(String var1);

    public void setReconnectBlockingTime(Long var1);

    public Value<Long> getReconnectPeriod();

    public void setReconnectPeriod(String var1);

    public void setReconnectPeriod(Long var1);
}

