/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.descriptors.jdbc.internal;

import org.eclipse.sapphire.Property;
import org.eclipse.sapphire.modeling.xml.XmlElement;
import org.eclipse.sapphire.modeling.xml.XmlNode;
import org.eclipse.sapphire.modeling.xml.XmlValueBindingImpl;
import org.eclipse.sapphire.modeling.xml.annotations.CustomXmlValueBinding;

public class ProfileTypeBinding
extends XmlValueBindingImpl {
    private static final String CONNECTION_POOL_PARAMS_PATH = "jdbc-connection-pool-params";
    private static final String PROFILE_TYPE_PATH = "profile-type";
    private int profileTypeParam = 0;

    public void init(Property property) {
        super.init(property);
        String[] params = ((CustomXmlValueBinding)property.definition().getAnnotation(CustomXmlValueBinding.class)).params();
        if (params.length > 0) {
            this.profileTypeParam = Integer.parseInt(params[0]);
        }
    }

    public String read() {
        XmlElement profileEl;
        XmlElement poolParamsEl;
        XmlElement el = this.xml(false);
        if (el != null && (poolParamsEl = el.getChildElement(CONNECTION_POOL_PARAMS_PATH, false)) != null && (profileEl = poolParamsEl.getChildElement(PROFILE_TYPE_PATH, false)) != null) {
            String profileStr = profileEl.getText();
            int profileVal = 0;
            try {
                profileVal = Integer.parseInt(profileStr);
            }
            catch (NumberFormatException numberFormatException) {
                profileVal = 0;
            }
            if (profileVal >= 0 && profileVal < 256 && (profileVal & this.profileTypeParam) != 0) {
                return "true";
            }
            return null;
        }
        return null;
    }

    public void write(String value) {
        XmlElement el = this.xml(true);
        if (el != null) {
            XmlElement poolParamsEl = el.getChildElement(CONNECTION_POOL_PARAMS_PATH, true);
            XmlElement profileEl = poolParamsEl.getChildElement(PROFILE_TYPE_PATH, true);
            String profileStr = profileEl.getText();
            int profileVal = 0;
            if (profileStr != null && profileStr.length() > 0) {
                try {
                    profileVal = Integer.parseInt(profileStr);
                }
                catch (NumberFormatException numberFormatException) {
                    profileVal = 0;
                }
            }
            if (profileVal > 255) {
                profileVal = 0;
            }
            if (value == null || value.equals("false")) {
                profileVal &= ~this.profileTypeParam;
            } else if (value.equals("true")) {
                profileVal |= this.profileTypeParam;
            }
            if (profileVal == 0) {
                profileEl.remove();
            } else {
                profileEl.setText(Integer.toString(profileVal));
            }
        }
    }

    public XmlNode getXmlNode() {
        XmlElement poolParamsEl;
        XmlElement el = this.xml(false);
        if (el != null && (poolParamsEl = el.getChildElement(CONNECTION_POOL_PARAMS_PATH, false)) != null) {
            return poolParamsEl.getChildElement(PROFILE_TYPE_PATH, false);
        }
        return null;
    }
}

