/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.descriptors.jdbc.internal;

import oracle.eclipse.tools.weblogic.descriptors.IWebLogicJdbcConfig;
import oracle.eclipse.tools.weblogic.descriptors.jdbc.DataSourceType;
import oracle.eclipse.tools.weblogic.descriptors.jdbc.internal.OracleParameterHelper;
import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.PropertyContentEvent;
import org.eclipse.sapphire.services.EnablementService;
import org.eclipse.sapphire.services.EnablementServiceData;

public final class OracleParametersEnablementService
extends EnablementService {
    private Listener listener;

    protected void initEnablementService() {
        this.listener = new FilteredListener<PropertyContentEvent>(){

            protected void handleTypedEvent(PropertyContentEvent event) {
                OracleParametersEnablementService.this.refresh();
            }
        };
        IWebLogicJdbcConfig config = (IWebLogicJdbcConfig)this.context(IWebLogicJdbcConfig.class);
        config.attach(this.listener, "ServerVersion");
        config.attach(this.listener, "DataSourceType");
        config.attach(this.listener, "DriverParameters/DatabaseType");
        config.attach(this.listener, "DriverParameters/DatabaseDriver");
    }

    protected EnablementServiceData compute() {
        IWebLogicJdbcConfig config = (IWebLogicJdbcConfig)this.context(IWebLogicJdbcConfig.class);
        if (config.getDataSourceType().validation().ok()) {
            if (((DataSourceType)((Object)config.getDataSourceType().content())).equals((Object)DataSourceType.MultiDataSource)) {
                return new EnablementServiceData(false);
            }
            return new EnablementServiceData(OracleParameterHelper.isOracleParameterEnabled(config));
        }
        return new EnablementServiceData(false);
    }

    public void dispose() {
        super.dispose();
        if (this.listener != null) {
            IWebLogicJdbcConfig config = (IWebLogicJdbcConfig)this.context(IWebLogicJdbcConfig.class);
            config.detach(this.listener, "ServerVersion");
            config.detach(this.listener, "DataSourceType");
            config.detach(this.listener, "DriverParameters/DatabaseType");
            config.detach(this.listener, "DriverParameters/DatabaseDriver");
        }
    }
}

