/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.descriptors.jdbc.internal;

import oracle.eclipse.tools.weblogic.descriptors.IWebLogicJdbcConfig;
import oracle.eclipse.tools.weblogic.descriptors.jdbc.DataSourceType;
import oracle.eclipse.tools.weblogic.descriptors.jdbc.IJdbcDriverParameters;
import oracle.eclipse.tools.weblogic.jdbc.IJDBCDbInfoFactory;
import oracle.eclipse.tools.weblogic.jdbc.IJDBCDriverInfo;
import oracle.eclipse.tools.weblogic.jdbc.JDBCInfoFactoryUtil;
import org.eclipse.core.resources.IProject;
import org.eclipse.sapphire.Version;

public class OracleParameterHelper {
    public static boolean isOracleParameterEnabled(IWebLogicJdbcConfig jdbcConfig) {
        boolean enabled = false;
        IJdbcDriverParameters driverParams = jdbcConfig.getDriverParameters();
        Version version = (Version)jdbcConfig.getServerVersion().content();
        if (version != null && version.matches("[10.3.4")) {
            IJDBCDriverInfo driverInfo;
            IProject project;
            IJDBCDbInfoFactory dbInfoFactory;
            if (((DataSourceType)((Object)jdbcConfig.getDataSourceType().content())).equals((Object)DataSourceType.GridLinkDataSource)) {
                return true;
            }
            String dbType = (String)driverParams.getDatabaseType().content();
            String dbDriver = (String)driverParams.getDatabaseDriver().content();
            if (dbType != null && dbDriver != null && (dbInfoFactory = JDBCInfoFactoryUtil.findJDBCDbInfoFactory(project = (IProject)driverParams.adapt(IProject.class), (Version)jdbcConfig.getServerVersion().content())) != null && (driverInfo = dbInfoFactory.getDriverInfo(dbType, dbDriver)) != null) {
                String dbVendor = driverInfo.getDbVendor();
                String driverVendor = driverInfo.getDriverVendor();
                if (dbVendor != null && dbVendor.equalsIgnoreCase("oracle") && driverVendor != null && driverVendor.equalsIgnoreCase("oracle")) {
                    enabled = true;
                }
            }
        }
        return enabled;
    }
}

