/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.descriptors.jdbc.internal;

import oracle.eclipse.tools.weblogic.descriptors.IWebLogicJdbcConfig;
import oracle.eclipse.tools.weblogic.descriptors.jdbc.DataSourceType;
import oracle.eclipse.tools.weblogic.descriptors.jdbc.internal.OracleParameterHelper;
import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.PropertyContentEvent;
import org.eclipse.sapphire.services.EnablementService;
import org.eclipse.sapphire.services.EnablementServiceData;

public final class OracleParameterEnabler
extends EnablementService {
    private Listener listener;

    protected void initEnablementService() {
        this.listener = new FilteredListener<PropertyContentEvent>(){

            protected void handleTypedEvent(PropertyContentEvent event) {
                OracleParameterEnabler.this.refresh();
            }
        };
        IWebLogicJdbcConfig config = (IWebLogicJdbcConfig)this.context(IWebLogicJdbcConfig.class);
        config.getDataSourceType().attach(this.listener);
        config.getDriverParameters().getDatabaseType().attach(this.listener);
        config.getDriverParameters().getDatabaseDriver().attach(this.listener);
    }

    protected EnablementServiceData compute() {
        IWebLogicJdbcConfig jdbcConfig = (IWebLogicJdbcConfig)this.context(IWebLogicJdbcConfig.class);
        if (((DataSourceType)((Object)jdbcConfig.getDataSourceType().content())).equals((Object)DataSourceType.MultiDataSource)) {
            return new EnablementServiceData(false);
        }
        return new EnablementServiceData(OracleParameterHelper.isOracleParameterEnabled(jdbcConfig));
    }

    public void dispose() {
        if (this.listener != null) {
            IWebLogicJdbcConfig config = (IWebLogicJdbcConfig)this.context(IWebLogicJdbcConfig.class);
            if (!config.disposed()) {
                config.getDataSourceType().detach(this.listener);
                config.getDriverParameters().getDatabaseType().detach(this.listener);
                config.getDriverParameters().getDatabaseDriver().detach(this.listener);
            }
            this.listener = null;
        }
        super.dispose();
    }
}

