/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.descriptors.jdbc.internal;

import oracle.eclipse.tools.weblogic.descriptors.jdbc.DriverType;
import org.eclipse.sapphire.modeling.xml.XmlElement;
import org.eclipse.sapphire.modeling.xml.XmlNode;
import org.eclipse.sapphire.modeling.xml.XmlValueBindingImpl;

public final class JdbcDriverTypeBinding
extends XmlValueBindingImpl {
    private static final String DATA_SOURCE_PARAMS_PATH = "jdbc-data-source-params";
    private static final String GLOBAL_TRANSACTION_PATH = "global-transactions-protocol";
    private static final String XA_PARAMS_PATH = "jdbc-xa-params";
    private static final String TWO_PHASE_COMMIT = "TwoPhaseCommit";

    public String read() {
        XmlElement globalTranEl;
        XmlElement dataSourceEl;
        XmlElement el = this.xml(false);
        if (el != null && (dataSourceEl = el.getChildElement(DATA_SOURCE_PARAMS_PATH, false)) != null && (globalTranEl = dataSourceEl.getChildElement(GLOBAL_TRANSACTION_PATH, false)) != null) {
            String protocol = globalTranEl.getText();
            if (protocol.equals(TWO_PHASE_COMMIT)) {
                return DriverType.XaDriver.toString();
            }
            return null;
        }
        return null;
    }

    public void write(String value) {
        XmlElement el = this.xml(true);
        if (el != null) {
            XmlElement dataSourceEl = el.getChildElement(DATA_SOURCE_PARAMS_PATH, true);
            XmlElement transactionEl = dataSourceEl.getChildElement(GLOBAL_TRANSACTION_PATH, true);
            if (value == null || value.equals(DriverType.NonXaDriver.toString())) {
                transactionEl.remove();
                XmlElement xaEl = el.getChildElement(XA_PARAMS_PATH, false);
                if (xaEl != null) {
                    xaEl.remove();
                }
            } else if (value.equals(DriverType.XaDriver.toString())) {
                transactionEl.setText(TWO_PHASE_COMMIT);
            }
        }
    }

    public XmlNode getXmlNode() {
        XmlElement dataSourceEl;
        XmlElement el = this.xml(false);
        if (el != null && (dataSourceEl = el.getChildElement(DATA_SOURCE_PARAMS_PATH, false)) != null) {
            return dataSourceEl.getChildElement(GLOBAL_TRANSACTION_PATH, false);
        }
        return null;
    }
}

