/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.descriptors.jdbc.internal;

import java.util.Map;
import java.util.Properties;
import java.util.Set;
import oracle.eclipse.tools.weblogic.descriptors.jdbc.IJdbcDriverParameters;
import oracle.eclipse.tools.weblogic.descriptors.jdbc.IJdbcHostPort;
import oracle.eclipse.tools.weblogic.descriptors.jdbc.IJdbcProperty;
import oracle.eclipse.tools.weblogic.jdbc.IJDBCDriverInfo;
import org.eclipse.sapphire.ElementList;
import org.eclipse.sapphire.modeling.xml.XmlElement;
import org.eclipse.sapphire.modeling.xml.XmlResource;

public class DriverURLHelper {
    public static String computeURL(IJdbcDriverParameters driverParam, IJDBCDriverInfo driverInfo, boolean isGridLink) {
        String dbName = null;
        String host = null;
        String port = null;
        String url = null;
        ElementList<IJdbcHostPort> hostPortList = null;
        if (!isGridLink) {
            dbName = (String)driverParam.getDatabaseName().content();
            host = (String)driverParam.getHostName().content();
            Integer portInteger = (Integer)driverParam.getPort().content();
            port = portInteger != null ? ((Integer)driverParam.getPort().content()).toString() : null;
        } else {
            hostPortList = driverParam.getHostPortList();
            if (hostPortList.size() > 0) {
                host = (String)((IJdbcHostPort)hostPortList.get(0)).getHostName().content();
                port = ((IJdbcHostPort)hostPortList.get(0)).getPort().content() != null ? ((Integer)((IJdbcHostPort)hostPortList.get(0)).getPort().content()).toString() : null;
            } else {
                return null;
            }
        }
        String user = (String)driverParam.getUser().content();
        String serviceName = (String)driverParam.getServiceName().content();
        String dataSource = (String)driverParam.getDataSource().content();
        String informixServer = (String)driverParam.getInformixServer().content();
        if (driverInfo.isUserNameRequired() && user == null || driverInfo.isHostNameRequired() && host == null || driverInfo.isPortRequired() && port == null || driverInfo.isServerNameRequired() && dbName == null) {
            return null;
        }
        if (!isGridLink) {
            driverInfo.setDbmsName(dbName);
            driverInfo.setDbmsHost(host);
            driverInfo.setDbmsPort(port);
        } else {
            for (IJdbcHostPort hostPort : hostPortList) {
                driverInfo.addHostPort((String)hostPort.getHostName().content(), (Integer)hostPort.getPort().content());
            }
        }
        driverInfo.setUser(user);
        driverInfo.setPassword("tiger");
        Set attrSet = driverInfo.getUnknownRequiredAttributes();
        for (String attrName : attrSet) {
            if (attrName.equals("DataSource")) {
                if (dataSource == null) {
                    return null;
                }
                driverInfo.setUnknownAttribute("DataSource", dataSource);
            }
            if (attrName.equals("ServiceName")) {
                if (serviceName == null) {
                    return null;
                }
                driverInfo.setUnknownAttribute("ServiceName", serviceName);
            }
            if (!attrName.equals("InformixServer")) continue;
            if (informixServer == null) {
                return null;
            }
            driverInfo.setUnknownAttribute("InformixServer", informixServer);
        }
        url = driverInfo.getURL();
        return url;
    }

    public static boolean driverPropertiesChanged(IJdbcDriverParameters driverParam, IJDBCDriverInfo driverInfo) {
        ElementList<IJdbcProperty> existingProps = driverParam.getDriverProperties();
        Properties props = driverInfo.getProperties();
        if (existingProps.size() != props.size()) {
            return true;
        }
        for (IJdbcProperty jdbcProp : existingProps) {
            String propName = (String)jdbcProp.getName().content();
            String propVal = (String)jdbcProp.getValue().content();
            String propVal2 = (String)props.get(propName);
            if (!(propVal == null && propVal2 != null || propVal != null && propVal2 == null) && (propVal == null || propVal2 == null || propVal.equals(propVal2))) continue;
            return true;
        }
        return false;
    }

    public static void clearDriverProperties(IJdbcDriverParameters driverParam) {
        ElementList<IJdbcProperty> allProps = driverParam.getDriverProperties();
        allProps.clear();
        XmlElement el = ((XmlResource)driverParam.adapt(XmlResource.class)).getXmlElement();
        XmlElement propsEl = el.getChildElement("properties", false);
        if (propsEl != null) {
            propsEl.remove();
        }
    }

    public static void updateDriverProperties(IJdbcDriverParameters driverParam, IJDBCDriverInfo driverInfo) {
        DriverURLHelper.clearDriverProperties(driverParam);
        ElementList<IJdbcProperty> allProps = driverParam.getDriverProperties();
        Properties props = driverInfo.getProperties();
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            String propName = (String)entry.getKey();
            String propValue = (String)entry.getValue();
            IJdbcProperty jdbcProp = (IJdbcProperty)allProps.insert();
            jdbcProp.setName(propName);
            if (propValue == null) continue;
            jdbcProp.setValue(propValue);
        }
    }
}

