/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.descriptors.jdbc.internal;

import java.util.ArrayList;
import java.util.List;
import oracle.eclipse.tools.weblogic.descriptors.jdbc.IJdbcDriverParameters;
import oracle.eclipse.tools.weblogic.descriptors.jdbc.internal.DbDriverRecord;
import oracle.eclipse.tools.weblogic.descriptors.jdbc.internal.DbDriversDatabase;
import oracle.eclipse.tools.weblogic.descriptors.jdbc.internal.DbProperty;
import org.eclipse.osgi.util.NLS;

public class DriverDefaultConfig {
    public static final String calculateDefaultUrl(IJdbcDriverParameters driverParam) {
        DbDriverRecord record;
        String url = null;
        String dbType = (String)driverParam.getDatabaseType().content();
        String dbDriver = (String)driverParam.getDatabaseDriver().content();
        if (dbType != null && dbDriver != null && (record = DbDriversDatabase.getDbDriverRecord(dbType, dbDriver)) != null) {
            String dbName = (String)driverParam.getDatabaseName().content();
            String host = (String)driverParam.getHostName().content();
            Integer portInteger = (Integer)driverParam.getPort().content();
            String port = portInteger != null ? ((Integer)driverParam.getPort().content()).toString() : null;
            String user = (String)driverParam.getUser().content();
            String serviceName = (String)driverParam.getServiceName().content();
            String dataSource = (String)driverParam.getDataSource().content();
            String informixServer = (String)driverParam.getInformixServer().content();
            String urlFormat = record.getUrl();
            if (urlFormat.indexOf("{0}") != -1 && dbName == null || urlFormat.indexOf("{1}") != -1 && host == null || urlFormat.indexOf("{2}") != -1 && port == null || urlFormat.indexOf("{3}") != -1 && user == null || urlFormat.indexOf("{4}") != -1 && serviceName == null || urlFormat.indexOf("{5}") != -1 && dataSource == null || urlFormat.indexOf("{6}") != -1 && informixServer == null) {
                return null;
            }
            Object[] params = new String[]{dbName, host, port, user, serviceName, dataSource, informixServer};
            url = NLS.bind((String)urlFormat, (Object[])params);
        }
        return url;
    }

    public static List<DbProperty> getDefaultProperties(IJdbcDriverParameters driverParam) {
        DbDriverRecord record;
        ArrayList<DbProperty> properties = new ArrayList<DbProperty>();
        String dbType = (String)driverParam.getDatabaseType().content();
        String dbDriver = (String)driverParam.getDatabaseDriver().content();
        if (dbType != null && dbDriver != null && (record = DbDriversDatabase.getDbDriverRecord(dbType, dbDriver)) != null) {
            String dbName = (String)driverParam.getDatabaseName().content();
            String host = (String)driverParam.getHostName().content();
            Integer portInteger = (Integer)driverParam.getPort().content();
            String port = portInteger != null ? portInteger.toString() : null;
            String user = (String)driverParam.getUser().content();
            String serviceName = (String)driverParam.getServiceName().content();
            String dataSource = (String)driverParam.getDataSource().content();
            String informixServer = (String)driverParam.getInformixServer().content();
            Object[] params = new String[]{dbName, host, port, user, serviceName, dataSource, informixServer};
            String propsFormat = record.getProperties();
            if (propsFormat != null) {
                String[] segments;
                String props = NLS.bind((String)propsFormat, (Object[])params);
                String[] stringArray = segments = props.split(",");
                int n = segments.length;
                int n2 = 0;
                while (n2 < n) {
                    String segment = stringArray[n2];
                    String[] propSeg = segment.split("=");
                    if (propSeg.length == 2) {
                        DbProperty prop = new DbProperty(propSeg[0], propSeg[1]);
                        properties.add(prop);
                    }
                    ++n2;
                }
            }
        }
        return properties;
    }

    public static List<String> getDriverPropertyNames(IJdbcDriverParameters driverParam, String propFormat) {
        String propsFormat;
        DbDriverRecord record;
        ArrayList<String> propNames = new ArrayList<String>();
        String dbType = (String)driverParam.getDatabaseType().content();
        String dbDriver = (String)driverParam.getDatabaseDriver().content();
        if (dbType != null && dbDriver != null && (record = DbDriversDatabase.getDbDriverRecord(dbType, dbDriver)) != null && (propsFormat = record.getProperties()) != null) {
            String[] segments;
            String[] stringArray = segments = propsFormat.split(",");
            int n = segments.length;
            int n2 = 0;
            while (n2 < n) {
                String propVal;
                String segment = stringArray[n2];
                String[] propSeg = segment.split("=");
                if (propSeg.length == 2 && (propVal = propSeg[1]).indexOf(propFormat) != -1) {
                    propNames.add(propSeg[0]);
                }
                ++n2;
            }
        }
        return propNames;
    }
}

