/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.descriptors.jdbc.internal;

import oracle.eclipse.tools.weblogic.descriptors.IWebLogicJdbcConfig;
import oracle.eclipse.tools.weblogic.descriptors.jdbc.DataSourceType;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.PropertyContentEvent;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.Version;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.services.ValidationService;

public class DataSourceTypeValidator
extends ValidationService {
    private Listener listener;

    protected void initValidationService() {
        super.initValidationService();
        this.listener = new FilteredListener<PropertyContentEvent>(){

            protected void handleTypedEvent(PropertyContentEvent event) {
                DataSourceTypeValidator.this.refresh();
            }
        };
        IWebLogicJdbcConfig config = (IWebLogicJdbcConfig)this.context(IWebLogicJdbcConfig.class);
        config.attach(this.listener, "ServerVersion");
    }

    protected Status compute() {
        Value dataSourceType = (Value)this.context(Value.class);
        IWebLogicJdbcConfig jdbcConfig = (IWebLogicJdbcConfig)dataSourceType.element().nearest(IWebLogicJdbcConfig.class);
        Version version = (Version)jdbcConfig.getServerVersion().content();
        if (!(dataSourceType.content() != DataSourceType.GridLinkDataSource || version != null && version.matches("[10.3.4"))) {
            return Status.createErrorStatus((String)Resources.invalidDataSourceType);
        }
        return Status.createOkStatus();
    }

    public void dispose() {
        if (this.listener != null) {
            IWebLogicJdbcConfig config = (IWebLogicJdbcConfig)this.context(IWebLogicJdbcConfig.class);
            config.detach(this.listener, "ServerVersion");
            this.listener = null;
        }
        super.dispose();
    }

    private static final class Resources
    extends NLS {
        public static String invalidDataSourceType;

        static {
            Resources.initializeMessages((String)DataSourceTypeValidator.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

