/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.descriptors.jdbc.internal;

import oracle.eclipse.tools.weblogic.descriptors.IWebLogicJdbcConfig;
import oracle.eclipse.tools.weblogic.descriptors.jdbc.DataSourceType;
import oracle.eclipse.tools.weblogic.descriptors.jdbc.IJdbcDriverParameters;
import org.eclipse.sapphire.modeling.xml.XmlElement;
import org.eclipse.sapphire.modeling.xml.XmlNode;
import org.eclipse.sapphire.modeling.xml.XmlResource;
import org.eclipse.sapphire.modeling.xml.XmlValueBindingImpl;

public class DataSourceTypeBinding
extends XmlValueBindingImpl {
    private static final String DATA_SOURCE_PARAMS_PATH = "jdbc-data-source-params";
    private static final String ALGORITHM_TYPE_PATH = "algorithm-type";
    private static final String DATA_SOURCE_LIST_PATH = "data-source-list";
    private static final String CALLBACK_HANDLER_PATH = "connection-pool-failover-callback-handler";
    private static final String FAILOVER_REQUEST_PATH = "failover-request-if-busy";
    private static final String ROW_PREFETCH_PATH = "row-prefetch";
    private static final String ROW_PREFETCH_SIZE_PATH = "row-prefetch-size";
    private static final String STREAM_CHUNK_SIZE_PATH = "stream-chunk-size";
    private static final String GLOBAL_TRANSACTION_PROTOCOL_PATH = "global-transactions-protocol";
    private static final String DATA_SOURCE_TYPE_PATH = "data-source-type";
    private static final String DRIVER_PARAMS_PATH = "jdbc-driver-params";
    private static final String CONNECTION_POOL_PARAMS_PATH = "jdbc-connection-pool-params";
    private static final String XA_PARAMS_PATH = "jdbc-xa-params";

    public String read() {
        XmlElement el = this.xml(false);
        if (el != null) {
            XmlElement driverParamsEl;
            String dataSourceType = el.getMetaCommentText(DATA_SOURCE_TYPE_PATH);
            if (dataSourceType != null) {
                if (dataSourceType.equals(DataSourceType.GridLinkDataSource.toString()) || dataSourceType.equals(DataSourceType.MultiDataSource.toString())) {
                    return dataSourceType;
                }
                return null;
            }
            XmlElement dataSourceEl = el.getChildElement(DATA_SOURCE_PARAMS_PATH, false);
            if (dataSourceEl != null) {
                XmlElement algoEl = dataSourceEl.getChildElement(ALGORITHM_TYPE_PATH, false);
                XmlElement sourceListEl = dataSourceEl.getChildElement(DATA_SOURCE_LIST_PATH, false);
                XmlElement callbackEl = dataSourceEl.getChildElement(CALLBACK_HANDLER_PATH, false);
                XmlElement failoverEl = dataSourceEl.getChildElement(FAILOVER_REQUEST_PATH, false);
                if (algoEl != null || sourceListEl != null || callbackEl != null || failoverEl != null) {
                    return DataSourceType.MultiDataSource.toString();
                }
            }
            if ((driverParamsEl = el.getChildElement(DRIVER_PARAMS_PATH, false)) != null) {
                String sub;
                int addrIndx;
                String url;
                String dbType = driverParamsEl.getMetaCommentText("database-type");
                String dbDriver = driverParamsEl.getMetaCommentText("database-driver");
                if (dbType == null) {
                    return null;
                }
                if (dbType != null && dbType.equalsIgnoreCase("oracle") && dbDriver != null && (dbDriver.equalsIgnoreCase("Oracle's Non XA Driver") || dbDriver.equalsIgnoreCase("Oracle's XA Driver"))) {
                    return DataSourceType.GridLinkDataSource.toString();
                }
                XmlElement urlEl = driverParamsEl.getChildElement("url", false);
                if (urlEl != null && (url = urlEl.getText()) != null && url.startsWith("jdbc:oracle:thin:") && url.indexOf("INSTANCE_NAME") == -1 && (addrIndx = url.indexOf("ADDRESS=")) > 0 && (sub = url.substring(addrIndx)) != null && sub.indexOf("ADDRESS=") != -1) {
                    return DataSourceType.GridLinkDataSource.toString();
                }
            }
        }
        return null;
    }

    public void write(String value) {
        XmlElement el = this.xml(true);
        XmlElement dataSourceEl = el.getChildElement(DATA_SOURCE_PARAMS_PATH, false);
        if (value != null && value.equals(DataSourceType.MultiDataSource.toString())) {
            XmlElement xaParamsEl;
            XmlElement connPoolParamsEl;
            el.setMetaCommentText(DATA_SOURCE_TYPE_PATH, value);
            XmlElement driverParamsEl = el.getChildElement(DRIVER_PARAMS_PATH, false);
            if (driverParamsEl != null) {
                driverParamsEl.remove();
            }
            if ((connPoolParamsEl = el.getChildElement(CONNECTION_POOL_PARAMS_PATH, false)) != null) {
                connPoolParamsEl.remove();
            }
            if ((xaParamsEl = el.getChildElement(XA_PARAMS_PATH, false)) != null) {
                xaParamsEl.remove();
            }
            if (dataSourceEl != null) {
                XmlElement transProctolEl;
                XmlElement streamSizeEl;
                XmlElement rowPrefetchSizeEl;
                XmlElement rowPrefetchEl = dataSourceEl.getChildElement(ROW_PREFETCH_PATH, false);
                if (rowPrefetchEl != null) {
                    rowPrefetchEl.remove();
                }
                if ((rowPrefetchSizeEl = dataSourceEl.getChildElement(ROW_PREFETCH_SIZE_PATH, false)) != null) {
                    rowPrefetchSizeEl.remove();
                }
                if ((streamSizeEl = dataSourceEl.getChildElement(STREAM_CHUNK_SIZE_PATH, false)) != null) {
                    streamSizeEl.remove();
                }
                if ((transProctolEl = dataSourceEl.getChildElement(GLOBAL_TRANSACTION_PROTOCOL_PATH, false)) != null) {
                    transProctolEl.remove();
                }
            }
        } else {
            el.setMetaCommentText(DATA_SOURCE_TYPE_PATH, value);
            if (dataSourceEl != null) {
                XmlElement failoverEl;
                XmlElement callbackEl;
                XmlElement listEl;
                XmlElement algoEl = dataSourceEl.getChildElement(ALGORITHM_TYPE_PATH, false);
                if (algoEl != null) {
                    algoEl.remove();
                }
                if ((listEl = dataSourceEl.getChildElement(DATA_SOURCE_LIST_PATH, false)) != null) {
                    listEl.remove();
                }
                if ((callbackEl = dataSourceEl.getChildElement(CALLBACK_HANDLER_PATH, false)) != null) {
                    callbackEl.remove();
                }
                if ((failoverEl = dataSourceEl.getChildElement(FAILOVER_REQUEST_PATH, false)) != null) {
                    failoverEl.remove();
                }
            }
            if (value == null || value.equals(DataSourceType.GenericDataSource.toString())) {
                XmlElement driverEl;
                IWebLogicJdbcConfig jdbcConfig = (IWebLogicJdbcConfig)this.property().nearest(IWebLogicJdbcConfig.class);
                IJdbcDriverParameters driverParameters = jdbcConfig.getDriverParameters();
                String dbType = (String)driverParameters.getDatabaseType().content();
                String dbDriver = (String)driverParameters.getDatabaseDriver().content();
                if (dbType != null && dbType.equalsIgnoreCase("oracle") && dbDriver != null && (dbDriver.equalsIgnoreCase("Oracle's Non XA Driver") || dbDriver.equalsIgnoreCase("Oracle's XA Driver")) && (driverEl = ((XmlResource)driverParameters.resource()).getXmlElement()) != null) {
                    driverEl.remove();
                }
            }
        }
        if (dataSourceEl != null && (dataSourceEl.getChildElements() == null || dataSourceEl.getChildElements().isEmpty())) {
            dataSourceEl.remove();
        }
    }

    public XmlNode getXmlNode() {
        XmlElement el = this.xml(false);
        if (el != null) {
            return el.getMetaComment(DATA_SOURCE_TYPE_PATH, false);
        }
        return null;
    }
}

