/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.descriptors.jdbc.internal;

import oracle.eclipse.tools.weblogic.descriptors.jdbc.IJdbcConnectionPoolParameters;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.PropertyContentEvent;
import org.eclipse.sapphire.PropertyDef;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.services.ValidationService;

public class ConnectionPoolCapacityValidator
extends ValidationService {
    private Listener listener;

    protected void initValidationService() {
        super.initValidationService();
        this.listener = new FilteredListener<PropertyContentEvent>(){

            protected void handleTypedEvent(PropertyContentEvent event) {
                ConnectionPoolCapacityValidator.this.refresh();
            }
        };
        IJdbcConnectionPoolParameters poolParams = (IJdbcConnectionPoolParameters)this.context(IJdbcConnectionPoolParameters.class);
        poolParams.attach(this.listener, "InitialCapacity");
        poolParams.attach(this.listener, "MaximumCapacity");
        poolParams.attach(this.listener, "MinimumCapacity");
    }

    protected Status compute() {
        Value obj = (Value)this.context(Value.class);
        if (obj != null) {
            IJdbcConnectionPoolParameters conParams = (IJdbcConnectionPoolParameters)obj.element().nearest(IJdbcConnectionPoolParameters.class);
            Integer initalCapObj = (Integer)conParams.getInitialCapacity().content();
            Integer maxCapObj = (Integer)conParams.getMaximumCapacity().content();
            Integer minCapObj = (Integer)conParams.getMinimumCapacity().content();
            if (this.context(PropertyDef.class) == IJdbcConnectionPoolParameters.PROP_INITIAL_CAPACITY) {
                if (initalCapObj != null && maxCapObj != null && initalCapObj > maxCapObj) {
                    return Status.createErrorStatus((String)Resources.initialMustBeSmallerThanMax);
                }
                if (conParams.getMinimumCapacity().enabled() && initalCapObj != null && minCapObj != null && initalCapObj < minCapObj) {
                    return Status.createErrorStatus((String)Resources.initialMustBeBiggerThanMin);
                }
            } else if (conParams.getMinimumCapacity().enabled() && maxCapObj != null && minCapObj != null && maxCapObj < minCapObj) {
                return Status.createErrorStatus((String)Resources.minMustBeSmallerThanMax);
            }
        }
        return Status.createOkStatus();
    }

    public void dispose() {
        if (this.listener != null) {
            IJdbcConnectionPoolParameters poolParams = (IJdbcConnectionPoolParameters)this.context(IJdbcConnectionPoolParameters.class);
            poolParams.detach(this.listener, "InitialCapacity");
            poolParams.detach(this.listener, "MaximumCapacity");
            poolParams.detach(this.listener, "MinimumCapacity");
            this.listener = null;
        }
        super.dispose();
    }

    private static final class Resources
    extends NLS {
        public static String initialMustBeSmallerThanMax;
        public static String initialMustBeBiggerThanMin;
        public static String minMustBeSmallerThanMax;

        static {
            Resources.initializeMessages((String)ConnectionPoolCapacityValidator.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

