/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.descriptors.jdbc;

import oracle.eclipse.tools.weblogic.descriptors.internal.PasswordBinding;
import oracle.eclipse.tools.weblogic.descriptors.jdbc.IONSNode;
import oracle.eclipse.tools.weblogic.descriptors.jdbc.internal.ONSNodesBinding;
import oracle.eclipse.tools.weblogic.descriptors.jdbc.internal.OracleParameterEnabler;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.ElementList;
import org.eclipse.sapphire.ElementType;
import org.eclipse.sapphire.ListProperty;
import org.eclipse.sapphire.ReferenceValue;
import org.eclipse.sapphire.Since;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.ValueProperty;
import org.eclipse.sapphire.java.JavaType;
import org.eclipse.sapphire.java.JavaTypeConstraint;
import org.eclipse.sapphire.java.JavaTypeKind;
import org.eclipse.sapphire.java.JavaTypeName;
import org.eclipse.sapphire.modeling.annotations.DefaultValue;
import org.eclipse.sapphire.modeling.annotations.Documentation;
import org.eclipse.sapphire.modeling.annotations.Label;
import org.eclipse.sapphire.modeling.annotations.NamedValues;
import org.eclipse.sapphire.modeling.annotations.NumericRange;
import org.eclipse.sapphire.modeling.annotations.Reference;
import org.eclipse.sapphire.modeling.annotations.SensitiveData;
import org.eclipse.sapphire.modeling.annotations.Service;
import org.eclipse.sapphire.modeling.annotations.Type;
import org.eclipse.sapphire.modeling.xml.annotations.CustomXmlListBinding;
import org.eclipse.sapphire.modeling.xml.annotations.CustomXmlValueBinding;
import org.eclipse.sapphire.modeling.xml.annotations.XmlBinding;

public interface IJdbcOracleParameters
extends Element {
    public static final ElementType TYPE = new ElementType(IJdbcOracleParameters.class);
    @Type(base=Boolean.class)
    @XmlBinding(path="fan-enabled")
    @Label(standard="fan enabled")
    @DefaultValue(text="false")
    @Service(impl=OracleParameterEnabler.class)
    @Documentation(content="Enables the data source to subscribe to and process Oracle FAN events.[pbr/]This attribute is only applicable for RAC configurations that publish FAN notification events using the ONS protocol.")
    public static final ValueProperty PROP_FAN_ENABLED = new ValueProperty(TYPE, "FanEnabled");
    @Label(standard="ONS nodes")
    @Type(base=IONSNode.class)
    @CustomXmlListBinding(impl=ONSNodesBinding.class)
    @Service(impl=OracleParameterEnabler.class)
    @Documentation(content="A comma-separate list of ONS daemon listen addresses and ports to which connect to for receiving ONS-based FAN events.")
    public static final ListProperty PROP_ONS_NODE_LIST = new ListProperty(TYPE, "OnsNodeList");
    @XmlBinding(path="ons-wallet-file")
    @Label(standard="ONS wallet file")
    @Service(impl=OracleParameterEnabler.class)
    @Documentation(content="The location of the Oracle wallet file in which the SSL certificates are stored. Only required when the ONS client is configured to communicate with ONS daemons using SSL.")
    public static final ValueProperty PROP_ONS_WALLET_FILE = new ValueProperty(TYPE, "OnsWalletFile");
    @Label(standard="ONS wallet password")
    @CustomXmlValueBinding(impl=PasswordBinding.class, params={"ons-wallet-password-encrypted"})
    @SensitiveData
    @Service(impl=OracleParameterEnabler.class)
    @Documentation(content="The wallet password attribute that is included as part of the ONS client configuration string. This attribute is only required when ONS is configured to use the SSL protocol.")
    public static final ValueProperty PROP_ONS_WALLET_PASSWORD = new ValueProperty(TYPE, "OnsWalletPassword");
    @XmlBinding(path="ons-wallet-password-encrypted")
    @Label(standard="ONS wallet password")
    @SensitiveData
    @Service(impl=OracleParameterEnabler.class)
    public static final ValueProperty PROP_ONS_WALLET_PASSWORD_ENCRYPTED = new ValueProperty(TYPE, "OnsWalletPasswordEncrypted");
    @Type(base=Boolean.class)
    @XmlBinding(path="oracle-enable-java-net-fast-path")
    @Label(standard="oracle reduced data copies")
    @Service(impl=OracleParameterEnabler.class)
    @Documentation(content="Enables the Oracle JDBC JavaNet Fastpath to reduce data copies and fragmentation.")
    public static final ValueProperty PROP_REDUCED_DATA_COPIES = new ValueProperty(TYPE, "ReducedDataCopies");
    @Type(base=Boolean.class)
    @XmlBinding(path="oracle-optimize-utf8-conversion")
    @Label(standard="oracle optimize UTF8 conversion")
    @Service(impl=OracleParameterEnabler.class)
    @Documentation(content="Enables the Oracle JDBC optimize UTF-8 conversion option.")
    public static final ValueProperty PROP_OPTIMIZE_UTF8_CONVERSION = new ValueProperty(TYPE, "OptimizeUtf8Conversion");
    @Type(base=JavaTypeName.class)
    @Reference(target=JavaType.class)
    @JavaTypeConstraint(kind={JavaTypeKind.CLASS})
    @XmlBinding(path="connection-initialization-callback")
    @Label(standard="connection initialization callback")
    @Service(impl=OracleParameterEnabler.class)
    @Since(value="10.3.6")
    @Documentation(content="The name of the connection initialization callback. This is automatically passed to registerConnectionInitializationCallback when the datasource is created.")
    public static final ValueProperty PROP_CONNECTION_INITIALIZATION_CALLBACK = new ValueProperty(TYPE, "ConnectionInitializationCallback");
    @XmlBinding(path="affinity-policy")
    @Label(standard="affinity policy")
    @Service(impl=OracleParameterEnabler.class)
    @Since(value="10.3.6")
    @Documentation(content="The preferred affinity policy for the data source.")
    public static final ValueProperty PROP_AFFINITY_POLICY = new ValueProperty(TYPE, "AffinityPolicy");
    @Type(base=Boolean.class)
    @XmlBinding(path="oracle-proxy-session")
    @Label(standard="oracle proxy session enabled")
    @DefaultValue(text="false")
    @Service(impl=OracleParameterEnabler.class)
    @Since(value="10.3.6")
    @Documentation(content="Enables the Oracle JDBC Proxy Authentication option.")
    public static final ValueProperty PROP_ORACLE_PROXY_SESSION_ENABLED = new ValueProperty(TYPE, "OracleProxySessionEnabled");
    @Type(base=Boolean.class)
    @XmlBinding(path="use-database-credentials")
    @Label(standard="use database credentials")
    @DefaultValue(text="false")
    @Service(impl=OracleParameterEnabler.class)
    @Since(value="10.3.6")
    @Documentation(content="When getting a connection, use database credentials instead of application server credentials.")
    public static final ValueProperty PROP_USE_DATABASE_CREDENTIALS = new ValueProperty(TYPE, "UseDatabaseCredentials");
    @NamedValues(arbitraryValueLabel="replay initiation timeout (sec)", defaultArbitraryValue="3600", namedValues={@NamedValues.NamedValue(value="0", label="no timeout")})
    @Type(base=Integer.class)
    @XmlBinding(path="replay-initiation-timeout")
    @Label(standard="replay initiation timeout")
    @NumericRange(min="0")
    @DefaultValue(text="3600")
    @Service(impl=OracleParameterEnabler.class)
    @Since(value="12.1.2")
    @Documentation(content="The timeout value for replay specified in seconds. Zero implies no timeout.")
    public static final ValueProperty PROP_REPLAY_INITIATION_TIMEOUT = new ValueProperty(TYPE, "ReplayInitiationTimeout");
    @Type(base=Boolean.class)
    @XmlBinding(path="active-gridlink")
    @Label(standard="active gridlink")
    @DefaultValue(text="false")
    @Service(impl=OracleParameterEnabler.class)
    @Since(value="12.1.2")
    @Documentation(content="A true value indicates a configured Active GridLink datasource. It is set to true when using the console to create an Active GridLink datasource.  It is ignored if fan-enabled is true or ons-node-list is a non-null string.")
    public static final ValueProperty PROP_ACTIVE_GRIDLINK = new ValueProperty(TYPE, "ActiveGridlink");

    public Value<Boolean> isFanEnabled();

    public void setFanEnabled(String var1);

    public void setFanEnabled(Boolean var1);

    public ElementList<IONSNode> getOnsNodeList();

    public Value<String> getOnsWalletFile();

    public void setOnsWalletFile(String var1);

    public Value<String> getOnsWalletPassword();

    public void setOnsWalletPassword(String var1);

    public Value<String> getOnsWalletPasswordEncrypted();

    public void setOnsWalletPasswordEncrypted(String var1);

    public Value<Boolean> isReducedDataCopies();

    public void setReducedDataCopies(String var1);

    public void setReducedDataCopies(Boolean var1);

    public Value<Boolean> isOptimizeUtf8Conversion();

    public void setOptimizeUtf8Conversion(String var1);

    public void setOptimizeUtf8Conversion(Boolean var1);

    public ReferenceValue<JavaTypeName, JavaType> getConnectionInitializationCallback();

    public void setConnectionInitializationCallback(String var1);

    public void setConnectionInitializationCallback(JavaTypeName var1);

    public Value<String> getAffinityPolicy();

    public void setAffinityPolicy(String var1);

    public Value<Boolean> isOracleProxySessionEnabled();

    public void setOracleProxySessionEnabled(String var1);

    public void setOracleProxySessionEnabled(Boolean var1);

    public Value<Boolean> isUseDatabaseCredentials();

    public void setUseDatabaseCredentials(String var1);

    public void setUseDatabaseCredentials(Boolean var1);

    public Value<Integer> getReplayInitiationTimeout();

    public void setReplayInitiationTimeout(String var1);

    public void setReplayInitiationTimeout(Integer var1);

    public Value<Boolean> isActiveGridlink();

    public void setActiveGridlink(String var1);

    public void setActiveGridlink(Boolean var1);
}

