/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.descriptors.jdbc;

import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.ElementType;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.ValueProperty;
import org.eclipse.sapphire.modeling.annotations.Documentation;
import org.eclipse.sapphire.modeling.annotations.Label;
import org.eclipse.sapphire.modeling.annotations.Type;
import org.eclipse.sapphire.modeling.xml.annotations.XmlBinding;

public interface IJdbcIdentityOptions
extends Element {
    public static final ElementType TYPE = new ElementType(IJdbcIdentityOptions.class);
    @Type(base=Boolean.class)
    @XmlBinding(path="jdbc-connection-pool-params/identity-based-connection-pooling-enabled")
    @Label(standard="enable identity based connection pooling")
    @Documentation(content="Enables identity-based-connection-pooling for the data source. When an application requests a database connection, WebLogic Server picks or creates a physical connection with requested DBMS identity based on a map of WebLogic user IDs and database IDs.[pbr/]You must also specify the map of WebLogic Server user IDs to database user IDs (credential mapping).")
    public static final ValueProperty PROP_IDENTITY_BASED_CONNECTION_POOLING_ENABLED = new ValueProperty(TYPE, "IdentityBasedConnectionPoolingEnabled");
    @Type(base=Boolean.class)
    @XmlBinding(path="jdbc-connection-pool-params/credential-mapping-enabled")
    @Label(standard="set client id on connection")
    @Documentation(content="Enables credential mapping for the data source. When an application requests a database connection, WebLogic Server sets a light-weight client ID on the database connection based on a map of database IDs.[pbr/]You must also specify the map of WebLogic Server user IDs to database user IDs (credential mapping).[pbr/]This feature relies on features in the JDBC driver and DBMS. It is not supported with all drivers and DBMSs.")
    public static final ValueProperty PROP_CREDENTIAL_MAPPING_ENABLED = new ValueProperty(TYPE, "CredentialMappingEnabled");

    public Value<Boolean> isIdentityBasedConnectionPoolingEnabled();

    public void setIdentityBasedConnectionPoolingEnabled(String var1);

    public void setIdentityBasedConnectionPoolingEnabled(Boolean var1);

    public Value<Boolean> isCredentialMappingEnabled();

    public void setCredentialMappingEnabled(String var1);

    public void setCredentialMappingEnabled(Boolean var1);
}

