/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.descriptors.jdbc;

import oracle.eclipse.tools.weblogic.descriptors.internal.PasswordBinding;
import oracle.eclipse.tools.weblogic.descriptors.jdbc.IJdbcHostPort;
import oracle.eclipse.tools.weblogic.descriptors.jdbc.IJdbcProperty;
import oracle.eclipse.tools.weblogic.descriptors.jdbc.internal.DatabaseConfigBinding;
import oracle.eclipse.tools.weblogic.descriptors.jdbc.internal.DatabaseDriverListener;
import oracle.eclipse.tools.weblogic.descriptors.jdbc.internal.DatabaseDriverValuesProvider;
import oracle.eclipse.tools.weblogic.descriptors.jdbc.internal.DatabaseTypeListener;
import oracle.eclipse.tools.weblogic.descriptors.jdbc.internal.DatabaseTypeValuesProvider;
import oracle.eclipse.tools.weblogic.descriptors.jdbc.internal.DbConfigListener;
import oracle.eclipse.tools.weblogic.descriptors.jdbc.internal.HostPortsBinding;
import oracle.eclipse.tools.weblogic.descriptors.jdbc.internal.UnknownDBPropertyEnabler;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.ElementList;
import org.eclipse.sapphire.ElementType;
import org.eclipse.sapphire.ListProperty;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.ValueProperty;
import org.eclipse.sapphire.modeling.annotations.Documentation;
import org.eclipse.sapphire.modeling.annotations.Enablement;
import org.eclipse.sapphire.modeling.annotations.Label;
import org.eclipse.sapphire.modeling.annotations.Listeners;
import org.eclipse.sapphire.modeling.annotations.SensitiveData;
import org.eclipse.sapphire.modeling.annotations.Service;
import org.eclipse.sapphire.modeling.annotations.Type;
import org.eclipse.sapphire.modeling.xml.annotations.CustomXmlListBinding;
import org.eclipse.sapphire.modeling.xml.annotations.CustomXmlValueBinding;
import org.eclipse.sapphire.modeling.xml.annotations.XmlBinding;
import org.eclipse.sapphire.modeling.xml.annotations.XmlListBinding;

public interface IJdbcDriverParameters
extends Element {
    public static final String E_DATABASE_NAME = "DatabaseName";
    public static final String E_HOST_NAME = "HostName";
    public static final String E_PORT = "Port";
    public static final String E_SERVICE_NAME = "ServiceName";
    public static final String E_DATA_SOURCE = "DataSource";
    public static final String E_USER = "User";
    public static final String E_INFORMIX_SERVER = "InformixServer";
    public static final ElementType TYPE = new ElementType(IJdbcDriverParameters.class);
    @Label(standard="database type")
    @CustomXmlValueBinding(impl=DatabaseConfigBinding.class, params={"database-type"})
    @Listeners(value={DatabaseTypeListener.class})
    @Service(impl=DatabaseTypeValuesProvider.class)
    @Enablement(expr="${ Parent.DataSourceType == 'GenericDataSource' }")
    public static final ValueProperty PROP_DATABASE_TYPE = new ValueProperty(TYPE, "DatabaseType");
    @Label(standard="database driver")
    @Service(impl=DatabaseDriverValuesProvider.class)
    @CustomXmlValueBinding(impl=DatabaseConfigBinding.class, params={"database-driver"})
    @Listeners(value={DatabaseDriverListener.class})
    public static final ValueProperty PROP_DATABASE_DRIVER = new ValueProperty(TYPE, "DatabaseDriver");
    @Label(standard="database name")
    @CustomXmlValueBinding(impl=DatabaseConfigBinding.class, params={"database-name"})
    @Listeners(value={DbConfigListener.class})
    @Enablement(expr="${ Parent.DataSourceType == 'GenericDataSource' }")
    public static final ValueProperty PROP_DATABASE_NAME = new ValueProperty(TYPE, "DatabaseName");
    @Label(standard="host name")
    @CustomXmlValueBinding(impl=DatabaseConfigBinding.class, params={"host-name"})
    @Listeners(value={DbConfigListener.class})
    @Enablement(expr="${ Parent.DataSourceType == 'GenericDataSource' }")
    public static final ValueProperty PROP_HOST_NAME = new ValueProperty(TYPE, "HostName");
    @Type(base=Integer.class)
    @Label(standard="port")
    @CustomXmlValueBinding(impl=DatabaseConfigBinding.class, params={"port"})
    @Listeners(value={DbConfigListener.class})
    @Enablement(expr="${ Parent.DataSourceType == 'GenericDataSource' }")
    public static final ValueProperty PROP_PORT = new ValueProperty(TYPE, "Port");
    @Label(standard="host and ports")
    @Type(base=IJdbcHostPort.class)
    @CustomXmlListBinding(impl=HostPortsBinding.class)
    @Enablement(expr="${ Parent.DataSourceType == 'GridLinkDataSource' }")
    @Listeners(value={DbConfigListener.class})
    public static final ListProperty PROP_HOST_PORT_LIST = new ListProperty(TYPE, "HostPortList");
    @Label(standard="service name")
    @CustomXmlValueBinding(impl=DatabaseConfigBinding.class, params={"service-name"})
    @Listeners(value={DbConfigListener.class})
    @Service(impl=UnknownDBPropertyEnabler.class, params={@Service.Param(name="property", value="ServiceName")})
    public static final ValueProperty PROP_SERVICE_NAME = new ValueProperty(TYPE, "ServiceName");
    @Label(standard="data source")
    @CustomXmlValueBinding(impl=DatabaseConfigBinding.class, params={"data-source"})
    @Listeners(value={DbConfigListener.class})
    @Service(impl=UnknownDBPropertyEnabler.class, params={@Service.Param(name="property", value="DataSource")})
    public static final ValueProperty PROP_DATA_SOURCE = new ValueProperty(TYPE, "DataSource");
    @Label(standard="informix server")
    @CustomXmlValueBinding(impl=DatabaseConfigBinding.class, params={"informix-server"})
    @Listeners(value={DbConfigListener.class})
    @Service(impl=UnknownDBPropertyEnabler.class, params={@Service.Param(name="property", value="InformixServer")})
    public static final ValueProperty PROP_INFORMIX_SERVER = new ValueProperty(TYPE, "InformixServer");
    @XmlBinding(path="url")
    @Label(standard="URL")
    @Documentation(content="The URL of the database to connect to. The format of the URL varies by JDBC driver.[pbr/]The URL is passed to the JDBC driver to create the physical database connections.")
    public static final ValueProperty PROP_URL = new ValueProperty(TYPE, "Url");
    @XmlBinding(path="driver-name")
    @Label(standard="driver class")
    @Documentation(content="The full package name of JDBC driver class used to create the physical database connections in the connection pool. (Note that this driver class must be in the classpath of any server to which it is deployed.)")
    public static final ValueProperty PROP_DRIVER_CLASS_NAME = new ValueProperty(TYPE, "DriverClassName");
    @Label(standard="user")
    @CustomXmlValueBinding(impl=DatabaseConfigBinding.class, params={"user"})
    @Listeners(value={DbConfigListener.class})
    @Documentation(content="The user attribute passed to the JDBC driver when creating physical database connections.[pbr/]The value is stored as a property of the list of properties.")
    public static final ValueProperty PROP_USER = new ValueProperty(TYPE, "User");
    @Label(standard="password")
    @CustomXmlValueBinding(impl=PasswordBinding.class, params={"password-encrypted"})
    @SensitiveData
    @Documentation(content="The password attribute passed to the JDBC driver when creating physical database connections.[pbr/]The value is stored in an encrypted form in the descriptor file.")
    public static final ValueProperty PROP_PASSWORD = new ValueProperty(TYPE, "Password");
    @XmlBinding(path="password-encrypted")
    @Label(standard="password")
    @SensitiveData
    public static final ValueProperty PROP_PASSWORD_ENCRYPTED = new ValueProperty(TYPE, "PasswordEncrypted");
    @Label(standard="properties")
    @Type(base=IJdbcProperty.class)
    @XmlListBinding(path="properties", mappings={@XmlListBinding.Mapping(element="property", type=IJdbcProperty.class)})
    @Documentation(content="The list of properties passed to the JDBC driver that are used to create physical database connections. For example: server=dbserver1. List each property=value pair on a separate line.[pbr/]To enable driver-level features, add the driver property and its value to the Properties list. WebLogic Server sets driver-level properties in the Properties list on the driver's ConnectionPoolDataSource object.[pbr/]Note: For security reasons, when WebLogic Server is running in Production mode, you cannot specify database passwords in this properties list. Data source deployment will fail if a password is specified in the properties list. To override this security check, use the command line argument \"weblogic.management.allowClearTextPasswords\" when starting the server.")
    public static final ListProperty PROP_DRIVER_PROPERTIES = new ListProperty(TYPE, "DriverProperties");

    public Value<String> getDatabaseType();

    public void setDatabaseType(String var1);

    public Value<String> getDatabaseDriver();

    public void setDatabaseDriver(String var1);

    public Value<String> getDatabaseName();

    public void setDatabaseName(String var1);

    public Value<String> getHostName();

    public void setHostName(String var1);

    public Value<Integer> getPort();

    public void setPort(String var1);

    public void setPort(Integer var1);

    public ElementList<IJdbcHostPort> getHostPortList();

    public Value<String> getServiceName();

    public void setServiceName(String var1);

    public Value<String> getDataSource();

    public void setDataSource(String var1);

    public Value<String> getInformixServer();

    public void setInformixServer(String var1);

    public Value<String> getUrl();

    public void setUrl(String var1);

    public Value<String> getDriverClassName();

    public void setDriverClassName(String var1);

    public Value<String> getUser();

    public void setUser(String var1);

    public Value<String> getPassword();

    public void setPassword(String var1);

    public Value<String> getPasswordEncrypted();

    public void setPasswordEncrypted(String var1);

    public ElementList<IJdbcProperty> getDriverProperties();
}

