/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.descriptors.jdbc;

import oracle.eclipse.tools.weblogic.descriptors.jdbc.internal.ProfileTypeBinding;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.ElementType;
import org.eclipse.sapphire.Since;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.ValueProperty;
import org.eclipse.sapphire.modeling.annotations.DefaultValue;
import org.eclipse.sapphire.modeling.annotations.Documentation;
import org.eclipse.sapphire.modeling.annotations.Label;
import org.eclipse.sapphire.modeling.annotations.NamedValues;
import org.eclipse.sapphire.modeling.annotations.NumericRange;
import org.eclipse.sapphire.modeling.annotations.Type;
import org.eclipse.sapphire.modeling.xml.annotations.CustomXmlValueBinding;
import org.eclipse.sapphire.modeling.xml.annotations.XmlBinding;

public interface IJdbcDiagnostics
extends Element {
    public static final ElementType TYPE = new ElementType(IJdbcDiagnostics.class);
    @Type(base=Boolean.class)
    @Label(standard="profile connection usage")
    @CustomXmlValueBinding(impl=ProfileTypeBinding.class, params={"1"})
    @DefaultValue(text="false")
    @Documentation(content="Collect profile information about threads currently using connections from the pool of connections in the data source.")
    public static final ValueProperty PROP_PROFILE_CONNECTION_USAGE = new ValueProperty(TYPE, "ProfileConnectionUsage");
    @Type(base=Boolean.class)
    @Label(standard="profile connection resevation wait")
    @CustomXmlValueBinding(impl=ProfileTypeBinding.class, params={"2"})
    @DefaultValue(text="false")
    @Documentation(content="Collect profile information about threads currently waiting to reserve a connection from the data source.")
    public static final ValueProperty PROP_PROFILE_RESERVATION_WAIT = new ValueProperty(TYPE, "ProfileReservationWait");
    @Type(base=Boolean.class)
    @Label(standard="profile connection leak")
    @CustomXmlValueBinding(impl=ProfileTypeBinding.class, params={"4"})
    @DefaultValue(text="false")
    @Documentation(content="Collect profile information about threads that have reserved a connection from the data source and the connection leaked (was not properly returned to the pool of connections). Set the Inactive Connection Timeout feature to a positive value to reclaim leaked connections.")
    public static final ValueProperty PROP_PROFILE_CONNECTION_LEAK = new ValueProperty(TYPE, "ProfileConnectionLeak");
    @Type(base=Boolean.class)
    @Label(standard="profile connection resevation failed")
    @CustomXmlValueBinding(impl=ProfileTypeBinding.class, params={"8"})
    @DefaultValue(text="false")
    @Documentation(content="Collect profile information about threads that attempt to reserve a connection from the data source but fail.")
    public static final ValueProperty PROP_PROFILE_RESERVATION_FAILED = new ValueProperty(TYPE, "ProfileReservationFailed");
    @Type(base=Boolean.class)
    @Label(standard="profile statement cache entry")
    @CustomXmlValueBinding(impl=ProfileTypeBinding.class, params={"16"})
    @DefaultValue(text="false")
    @Documentation(content="Collect profile information for prepared and callable statements added to the statement cache, and for the threads that originated the cached statements.")
    public static final ValueProperty PROP_PROFILE_STATEMENT_CACHE_ENTRY = new ValueProperty(TYPE, "ProfileStatementCacheEntry");
    @Type(base=Boolean.class)
    @Label(standard="profile statement usage")
    @CustomXmlValueBinding(impl=ProfileTypeBinding.class, params={"32"})
    @DefaultValue(text="false")
    @Documentation(content="Collect profile information about threads currently executing SQL statements from the statement cache.")
    public static final ValueProperty PROP_PROFILE_STATEMENT_USAGE = new ValueProperty(TYPE, "ProfileStatementUsage");
    @Type(base=Boolean.class)
    @Label(standard="profile connection last usage")
    @CustomXmlValueBinding(impl=ProfileTypeBinding.class, params={"64"})
    @DefaultValue(text="false")
    @Documentation(content="Collect profile information about the previous thread that last used the connection.[pbr/]This information is useful when debugging problems with connections infected with pending transactions that cause subsequent XA operations on the connections to fail.")
    public static final ValueProperty PROP_PROFILE_CONNECTION_LAST_USAGE = new ValueProperty(TYPE, "ProfileConnectionLastUsage");
    @Type(base=Boolean.class)
    @Label(standard="profile connection multithreaded usage")
    @CustomXmlValueBinding(impl=ProfileTypeBinding.class, params={"128"})
    @DefaultValue(text="false")
    @Documentation(content="Collect profile information about threads that erroneously use a connection previously obtained by a different thread.")
    public static final ValueProperty PROP_PROFILE_CONNECTION_MULTITHREADED_USAGE = new ValueProperty(TYPE, "ProfileConnectionMultithreadedUsage");
    @NamedValues(arbitraryValueLabel="Profile harvest frequency (secs)", defaultArbitraryValue="300", namedValues={@NamedValues.NamedValue(value="0", label="disable harvesting of data")})
    @Type(base=Integer.class)
    @XmlBinding(path="jdbc-connection-pool-params/profile-harvest-frequency-seconds")
    @Label(standard="The number of seconds between when WLS harvests profile data")
    @NumericRange(min="0")
    @DefaultValue(text="300")
    @Documentation(content="The number of seconds between when WebLogic Server harvests profile data.[pbr/]When set to 0, harvesting of data is disabled.")
    public static final ValueProperty PROP_PROFILE_HARVEST_FREQUENCY = new ValueProperty(TYPE, "ProfileHarvestFrequency");
    @XmlBinding(path="jdbc-connection-pool-params/driver-interceptor")
    @Label(standard="driver interceptor")
    @Documentation(content="Specifies the absolute name of the application class used to intercept method calls to the JDBC driver. The application specified must implement the weblogic.jdbc.extensions.DriverInterceptor interface.[pbr/]Weblogic Server will invoke the preInvokeCallback(), postInvokeExceptionCallback(), and postInvokeCallback() methods of the registered application before and after invoking any method inside the JDBC driver. You can use this feature to profile JDBC driver usage and monitor:[ul][li]Methods being executed[/li][li]Any exceptions thrown[/li][li]Time spent inside the driver executing methods[/li][/ul]")
    public static final ValueProperty PROP_DRIVER_INTERCEPTOR = new ValueProperty(TYPE, "DriverInterceptor");
    @Type(base=Integer.class)
    @XmlBinding(path="jdbc-connection-pool-params/connection-harvest-max-count")
    @Label(standard="the maximum number of connections that may be harvested")
    @NumericRange(min="1")
    @DefaultValue(text="1")
    @Since(value="10.3.6")
    @Documentation(content="The maximum number of connections that may be harvested when the connection harvesting occurs. The range of valid values is 1 to maxCapacity. Defaults to 1.")
    public static final ValueProperty PROP_CONNECTION_HARVEST_MAX_COUNT = new ValueProperty(TYPE, "ConnectionHarvestMaxCount");
    @NamedValues(arbitraryValueLabel="connection harvest trigger count", defaultArbitraryValue="1", namedValues={@NamedValues.NamedValue(value="-1", label="disable harvesting of connection")})
    @Type(base=Integer.class)
    @XmlBinding(path="jdbc-connection-pool-params/connection-harvest-trigger-count")
    @Label(standard="The number of connections below which connection harvesting will occur.")
    @NumericRange(min="-1")
    @DefaultValue(text="-1")
    @Since(value="10.3.6")
    @Documentation(content="The number of available connections below which the connection pool's connection harvesting will occur. The range of valid values is 0 to maxCapacity. Defaults to -1. Setting the value to -1 disables connection harvesting.")
    public static final ValueProperty PROP_CONNECTION_HARVEST_TRIGGER_COUNT = new ValueProperty(TYPE, "ConnectionHarvestTriggerCount");
    @Type(base=Integer.class)
    @XmlBinding(path="jdbc-connection-pool-params/count-of-test-failures-till-flush")
    @Label(standard="test failures count till flush")
    @NumericRange(min="1")
    @Since(value="12.1.2")
    @Documentation(content="Specifies the number of test failures allowed before WebLogic Platform closes all connections in the connection pool to minimize the delay caused by further database testing. This parameter minimizes the amount of time allowed for failover when a Multi Data Source member fails.")
    public static final ValueProperty PROP_COUNT_OF_TEST_FAILURES_TILL_FLUSH = new ValueProperty(TYPE, "CountOfTestFailuresTillFlush");
    @Type(base=Integer.class)
    @XmlBinding(path="jdbc-connection-pool-params/count-of-refresh-failures-till-disable")
    @Label(standard="refresh failures count till disable")
    @NumericRange(min="1")
    @Since(value="12.1.2")
    @Documentation(content="Specifies the number of test failures allowed before WebLogic Server disables the connection pool to minimize the delay in handling the connection request caused by a database failure.")
    public static final ValueProperty PROP_COUNT_OF_REFRESH_FAILURES_TILL_DISABLE = new ValueProperty(TYPE, "CountOfRefreshFailuresTillDisable");
    @Type(base=Boolean.class)
    @XmlBinding(path="jdbc-connection-pool-params/wrap-jdbc")
    @Label(standard="wrap jdbc")
    @DefaultValue(text="true")
    @Since(value="12.1.2")
    @Documentation(content="By default, SQL objects CallableStatement, PreparedStatement, ResultSet, Statement, and DatabaseMetaData are wrapped with a WebLogic wrapper. This allows for features like debugging and connection usage to be done by the server. [pbr/]The wrapping can be turned off by setting this value to false.This improves performance, in some cases significantly, and allows for the application to use the native driver objects directly. Setting this to false also turns off data type wrapping.")
    public static final ValueProperty PROP_WRAP_JDBC = new ValueProperty(TYPE, "WrapJdbc");

    public Value<Boolean> getProfileConnectionUsage();

    public void setProfileConnectionUsage(String var1);

    public void setProfileConnectionUsage(Boolean var1);

    public Value<Boolean> getProfileReservationWait();

    public void setProfileReservationWait(String var1);

    public void setProfileReservationWait(Boolean var1);

    public Value<Boolean> getProfileConnectionLeak();

    public void setProfileConnectionLeak(String var1);

    public void setProfileConnectionLeak(Boolean var1);

    public Value<Boolean> getProfileReservationFailed();

    public void setProfileReservationFailed(String var1);

    public void setProfileReservationFailed(Boolean var1);

    public Value<Boolean> getProfileStatementCacheEntry();

    public void setProfileStatementCacheEntry(String var1);

    public void setProfileStatementCacheEntry(Boolean var1);

    public Value<Boolean> getProfileStatementUsage();

    public void setProfileStatementUsage(String var1);

    public void setProfileStatementUsage(Boolean var1);

    public Value<Boolean> getProfileConnectionLastUsage();

    public void setProfileConnectionLastUsage(String var1);

    public void setProfileConnectionLastUsage(Boolean var1);

    public Value<Boolean> getProfileConnectionMultithreadedUsage();

    public void setProfileConnectionMultithreadedUsage(String var1);

    public void setProfileConnectionMultithreadedUsage(Boolean var1);

    public Value<Integer> getProfileHarvestFrequency();

    public void setProfileHarvestFrequency(String var1);

    public void setProfileHarvestFrequency(Integer var1);

    public Value<String> getDriverInterceptor();

    public void setDriverInterceptor(String var1);

    public Value<Integer> getConnectionHarvestMaxCount();

    public void setConnectionHarvestMaxCount(String var1);

    public void setConnectionHarvestMaxCount(Integer var1);

    public Value<Integer> getConnectionHarvestTriggerCount();

    public void setConnectionHarvestTriggerCount(String var1);

    public void setConnectionHarvestTriggerCount(Integer var1);

    public Value<Integer> getCountOfTestFailuresTillFlush();

    public void setCountOfTestFailuresTillFlush(String var1);

    public void setCountOfTestFailuresTillFlush(Integer var1);

    public Value<Integer> getCountOfRefreshFailuresTillDisable();

    public void setCountOfRefreshFailuresTillDisable(String var1);

    public void setCountOfRefreshFailuresTillDisable(Integer var1);

    public Value<Boolean> isWrapJdbc();

    public void setWrapJdbc(String var1);

    public void setWrapJdbc(Boolean var1);
}

