/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.descriptors.jdbc;

import oracle.eclipse.tools.weblogic.descriptors.IDatabaseDriverParameters;
import oracle.eclipse.tools.weblogic.descriptors.jdbc.AlgorithmType;
import oracle.eclipse.tools.weblogic.descriptors.jdbc.DataSourceType;
import oracle.eclipse.tools.weblogic.descriptors.jdbc.IJdbcDataSource;
import oracle.eclipse.tools.weblogic.descriptors.jdbc.IJndiName;
import oracle.eclipse.tools.weblogic.descriptors.jdbc.internal.DataSourceTypeBinding;
import oracle.eclipse.tools.weblogic.descriptors.jdbc.internal.DataSourceTypeListener;
import oracle.eclipse.tools.weblogic.descriptors.jdbc.internal.DataSourceTypeValidator;
import oracle.eclipse.tools.weblogic.descriptors.jdbc.internal.DataSourcesBinding;
import org.eclipse.sapphire.ElementList;
import org.eclipse.sapphire.ElementType;
import org.eclipse.sapphire.ListProperty;
import org.eclipse.sapphire.ReferenceValue;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.ValueProperty;
import org.eclipse.sapphire.java.JavaType;
import org.eclipse.sapphire.java.JavaTypeConstraint;
import org.eclipse.sapphire.java.JavaTypeKind;
import org.eclipse.sapphire.java.JavaTypeName;
import org.eclipse.sapphire.modeling.annotations.DefaultValue;
import org.eclipse.sapphire.modeling.annotations.Documentation;
import org.eclipse.sapphire.modeling.annotations.Enablement;
import org.eclipse.sapphire.modeling.annotations.Label;
import org.eclipse.sapphire.modeling.annotations.Listeners;
import org.eclipse.sapphire.modeling.annotations.Reference;
import org.eclipse.sapphire.modeling.annotations.Service;
import org.eclipse.sapphire.modeling.annotations.Type;
import org.eclipse.sapphire.modeling.xml.annotations.CustomXmlListBinding;
import org.eclipse.sapphire.modeling.xml.annotations.CustomXmlValueBinding;
import org.eclipse.sapphire.modeling.xml.annotations.XmlBinding;
import org.eclipse.sapphire.modeling.xml.annotations.XmlListBinding;

public interface IJdbcDataSourceParameters
extends IDatabaseDriverParameters {
    public static final ElementType TYPE = new ElementType(IJdbcDataSourceParameters.class);
    @Type(base=DataSourceType.class)
    @Label(standard="data source type")
    @CustomXmlValueBinding(impl=DataSourceTypeBinding.class)
    @DefaultValue(text="GenericDataSource")
    @Listeners(value={DataSourceTypeListener.class})
    @Service(impl=DataSourceTypeValidator.class)
    @Documentation(content="Applications get a database connection from a data source by looking up the data source on the Java Naming and Directory Interface (JNDI) tree and then requesting a connection. The data source provides the connection to the application from its pool of database connections.[pbr/]A JDBC multi data source is an abstraction around a group of data sources that provides load balancing and failover between data sources.")
    public static final ValueProperty PROP_DATA_SOURCE_TYPE = new ValueProperty(TYPE, "DataSourceType");
    @Type(base=IJndiName.class)
    @Label(standard="JNDI names")
    @XmlListBinding(path="jdbc-data-source-params", mappings={@XmlListBinding.Mapping(element="jndi-name", type=IJndiName.class)})
    @Documentation(content="The JNDI path to where this data source is bound. By default, the JNDI name is the name of the data source.[pbr/]To specify multiple JNDI names for the data source, enter each JNDI name on a separate line.")
    public static final ListProperty PROP_JNDI_NAMES = new ListProperty(TYPE, "JndiNames");
    @XmlBinding(path="jdbc-data-source-params/row-prefetch")
    @Enablement(expr="${ DataSourceType == 'GenericDataSource' || DataSourceType == 'GridLinkDataSource' }")
    @Documentation(content="Enables multiple rows to be \"prefetched\" (that is, sent from the server to the client) in one server access.[pbr/]When an external client accesses a database using JDBC through WebLogic Server, row prefetching improves performance by fetching multiple rows from the server to the client in one server access. WebLogic Server ignores this setting and does not use row prefetching when the client and WebLogic Server are in the same JVM.")
    public static final ValueProperty PROP_ROW_PREFETCH_ENABLED = new ValueProperty(TYPE, IDatabaseDriverParameters.PROP_ROW_PREFETCH_ENABLED);
    @XmlBinding(path="jdbc-data-source-params/row-prefetch-size")
    @Enablement(expr="${ DataSourceType == 'GenericDataSource' || DataSourceType == 'GridLinkDataSource' }")
    @Documentation(content="If row prefetching is enabled, specifies the number of result set rows to prefetch for a client.[pbr/]The optimal prefetch size depends on the particulars of the query. In general, increasing this number will increase performance, until a particular value is reached. At that point further increases do not result in any significant performance increase. Very rarely will increased performance result from exceeding 100 rows. The default value should be reasonable for most situations.")
    public static final ValueProperty PROP_ROW_PREFETCH_SIZE = new ValueProperty(TYPE, IDatabaseDriverParameters.PROP_ROW_PREFETCH_SIZE);
    @XmlBinding(path="jdbc-data-source-params/stream-chunk-size")
    @Label(standard="stream chunk size ")
    @DefaultValue(text="256")
    @Enablement(expr="${ DataSourceType == 'GenericDataSource' || DataSourceType == 'GridLinkDataSource' }")
    @Documentation(content="Specifies the data chunk size for steaming data types.[pbr/]Streaming data types (for example resulting from a call to getBinaryStream()) are sent in sized chunks from WebLogic Server to the client as needed.")
    public static final ValueProperty PROP_STREAM_CHUNK_SIZE = new ValueProperty(TYPE, IDatabaseDriverParameters.PROP_STREAM_CHUNK_SIZE);
    @Type(base=AlgorithmType.class)
    @XmlBinding(path="jdbc-data-source-params/algorithm-type")
    @Label(standard="algorithm type")
    @Enablement(expr="${ DataSourceType == 'MultiDataSource' }")
    public static final ValueProperty PROP_ALGORITHM_TYPE = new ValueProperty(TYPE, "AlgorithmType");
    @Label(standard="data sources")
    @Type(base=IJdbcDataSource.class)
    @CustomXmlListBinding(impl=DataSourcesBinding.class)
    @Enablement(expr="${ DataSourceType == 'MultiDataSource' }")
    public static final ListProperty PROP_DATA_SOURCE_LIST = new ListProperty(TYPE, "DataSourceList");
    @Type(base=JavaTypeName.class)
    @Reference(target=JavaType.class)
    @JavaTypeConstraint(kind={JavaTypeKind.CLASS}, type={"weblogic.jdbc.extensions.ConnectionPoolFailoverCallback"})
    @XmlBinding(path="jdbc-data-source-params/connection-pool-failover-callback-handler")
    @Label(standard="failover callback handler")
    @Enablement(expr="${ DataSourceType == 'MultiDataSource' }")
    @Documentation(content="The name of the application class to handle the callback sent when a multi data source is ready to failover or fail back connection requests to another data source within the multi data ource.[pbr/]The name must be the absolute name of an application class that implements the weblogic.jdbc.extensions.ConnectionPoolFailoverCallback interface.")
    public static final ValueProperty PROP_FAILOVER_CALLBACK_HANDLER = new ValueProperty(TYPE, "FailoverCallbackHandler");
    @Type(base=Boolean.class)
    @XmlBinding(path="jdbc-data-source-params/failover-request-if-busy")
    @Label(standard="failover request if busy")
    @Enablement(expr="${ DataSourceType == 'MultiDataSource' }")
    @Documentation(content="For multi data sources with the failover algorithm, enables the multi data source to failover connection requests to the next data source if all connections in the current data source are in use.")
    public static final ValueProperty PROP_FAILOVER_REQUEST_ENABLED = new ValueProperty(TYPE, "FailoverRequestEnabled");

    public Value<DataSourceType> getDataSourceType();

    public void setDataSourceType(DataSourceType var1);

    public void setDataSourceType(String var1);

    public ElementList<IJndiName> getJndiNames();

    public Value<AlgorithmType> getAlgorithmType();

    public void setAlgorithmType(AlgorithmType var1);

    public void setAlgorithmType(String var1);

    public ElementList<IJdbcDataSource> getDataSourceList();

    public ReferenceValue<JavaTypeName, JavaType> getFailoverCallbackHandler();

    public void setFailoverCallbackHandler(String var1);

    public void setFailoverCallbackHandler(JavaTypeName var1);

    public Value<Boolean> isFailoverRequestEnabled();

    public void setFailoverRequestEnabled(Boolean var1);

    public void setFailoverRequestEnabled(String var1);
}

