/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.descriptors.internal;

import oracle.eclipse.tools.common.util.StringEncrypter;
import org.eclipse.sapphire.Property;
import org.eclipse.sapphire.modeling.xml.XmlElement;
import org.eclipse.sapphire.modeling.xml.XmlValueBindingImpl;
import org.eclipse.sapphire.modeling.xml.annotations.CustomXmlValueBinding;

public class PasswordBinding
extends XmlValueBindingImpl {
    private static final String DEFAULT_PASSWORD_PATH = "password-encrypted";
    private String passwordPath = null;

    public void init(Property property) {
        super.init(property);
        String[] params = ((CustomXmlValueBinding)property.definition().getAnnotation(CustomXmlValueBinding.class)).params();
        this.passwordPath = params.length > 0 ? params[0] : DEFAULT_PASSWORD_PATH;
    }

    public String read() {
        String encryptedPassword;
        XmlElement el = this.xml(false);
        String string = encryptedPassword = el == null ? null : el.getMetaCommentText(this.passwordPath);
        if (encryptedPassword != null) {
            return StringEncrypter.getInstance().decrypt(encryptedPassword);
        }
        return null;
    }

    public void write(String value) {
        if (value != null) {
            value = StringEncrypter.getInstance().encrypt(value);
        }
        this.xml(true).setMetaCommentText(this.passwordPath, value);
    }
}

