/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.descriptors.internal;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import oracle.eclipse.tools.common.util.DomUtil;
import oracle.eclipse.tools.weblogic.descriptors.ILibraryContextRootOverride;
import oracle.eclipse.tools.weblogic.descriptors.ILibraryRef;
import oracle.eclipse.tools.weblogic.descriptors.IWebLogicAppDescriptor;
import oracle.eclipse.tools.weblogic.internal.WlsCorePlugin;
import oracle.eclipse.tools.weblogic.j2eelib.LibraryModule;
import oracle.eclipse.tools.weblogic.j2eelib.LibraryModulesSvc;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jst.j2ee.application.Application;
import org.eclipse.jst.j2ee.application.WebModule;
import org.eclipse.jst.j2ee.model.IModelProvider;
import org.eclipse.jst.j2ee.model.ModelProviderManager;
import org.eclipse.jst.javaee.application.Module;
import org.eclipse.jst.javaee.application.Web;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sapphire.ElementList;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.services.ValidationService;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;
import org.w3c.dom.Element;

public final class LibraryContextRootOverridesValidator
extends ValidationService {
    private static final String EL_MODULE = "module";
    private static final String EL_WEB = "web";
    private static final String EL_CONTEXT_ROOT = "context-root";

    protected Status compute() {
        ElementList list = (ElementList)this.context(ElementList.of(ILibraryContextRootOverride.class));
        if (list.isEmpty()) {
            return Status.createOkStatus();
        }
        IWebLogicAppDescriptor descriptor = (IWebLogicAppDescriptor)list.element().nearest(IWebLogicAppDescriptor.class);
        HashSet<String> libraryContextRoots = new HashSet<String>();
        for (ILibraryContextRootOverride override : list) {
            String libraryContextRoot = override.getLibraryContextRoot().text();
            String overridingContextRoot = override.getOverridingContextRoot().text();
            if (libraryContextRoot == null || overridingContextRoot == null) continue;
            if (libraryContextRoots.contains(libraryContextRoot)) {
                String msg = NLS.bind((String)Resources.libraryContextRootSpecifiedMoreThanOnce, (Object)libraryContextRoot);
                return Status.createErrorStatus((String)msg);
            }
            libraryContextRoots.add(libraryContextRoot);
            if (!libraryContextRoot.equals(overridingContextRoot)) continue;
            String msg = NLS.bind((String)Resources.noChangeOverride, (Object)libraryContextRoot);
            return Status.createErrorStatus((String)msg);
        }
        Map<String, Set<ContextRootSource>> contextRootInfo = LibraryContextRootOverridesValidator.analyzeContextRoots(descriptor);
        for (Map.Entry<String, Set<ContextRootSource>> entry : contextRootInfo.entrySet()) {
            String contextRoot = entry.getKey();
            Set<ContextRootSource> sources = entry.getValue();
            ContextRootSource overrideSource = null;
            ContextRootSource anotherSource = null;
            for (ContextRootSource source : sources) {
                if (source.type == ContextRootSourceType.LIBRARY_OVERRIDE && overrideSource == null) {
                    overrideSource = source;
                    if (anotherSource == null) continue;
                    break;
                }
                anotherSource = source;
                if (overrideSource != null) break;
            }
            if (overrideSource == null || anotherSource == null) continue;
            switch (anotherSource.type) {
                case PROJECT: {
                    String pjname = ((IProject)anotherSource.data).getName();
                    String msg = NLS.bind((String)Resources.overrideCollisionWithProject, (Object)contextRoot, (Object)pjname);
                    return Status.createErrorStatus((String)msg);
                }
                case LIBRARY: {
                    String msg = NLS.bind((String)Resources.overrideCollisionWithLibrary, (Object)contextRoot);
                    return Status.createErrorStatus((String)msg);
                }
                case LIBRARY_OVERRIDE: {
                    String msg = NLS.bind((String)Resources.overrideCollesionWithLibraryOverride, (Object)contextRoot);
                    return Status.createErrorStatus((String)msg);
                }
            }
        }
        return Status.createOkStatus();
    }

    private static Map<String, Set<ContextRootSource>> analyzeContextRoots(IWebLogicAppDescriptor descriptor) {
        HashMap<String, Set<ContextRootSource>> result = new HashMap<String, Set<ContextRootSource>>();
        for (String libContextRoot : LibraryContextRootOverridesValidator.getLibraryContextRoots(descriptor)) {
            LibraryContextRootOverridesValidator.addToResult(result, libContextRoot, new ContextRootSource(ContextRootSourceType.LIBRARY, null));
        }
        for (ILibraryContextRootOverride override : descriptor.getLibraryContextRootOverrides()) {
            String libraryContextRoot = override.getLibraryContextRoot().text();
            String overridingContextRoot = override.getOverridingContextRoot().text();
            if (libraryContextRoot == null || overridingContextRoot == null) continue;
            Set sources = (Set)result.get(libraryContextRoot);
            if (sources != null) {
                Iterator itr = sources.iterator();
                while (itr.hasNext()) {
                    ContextRootSource source = (ContextRootSource)itr.next();
                    if (source.type != ContextRootSourceType.LIBRARY) continue;
                    itr.remove();
                }
            }
            LibraryContextRootOverridesValidator.addToResult(result, overridingContextRoot, new ContextRootSource(ContextRootSourceType.LIBRARY_OVERRIDE, override));
        }
        IProject project = (IProject)descriptor.adapt(IProject.class);
        if (project != null) {
            IVirtualComponent earComp;
            String contextRoot;
            HashMap<String, String> webModuleUriToContextRoot = new HashMap<String, String>();
            IModelProvider modelProvider = ModelProviderManager.getModelProvider((IProject)project);
            if (modelProvider != null) {
                String uri;
                Web webModule;
                org.eclipse.jst.javaee.application.Application app;
                Object model = modelProvider.getModelObject();
                if (model instanceof org.eclipse.jst.javaee.application.Application) {
                    app = (org.eclipse.jst.javaee.application.Application)model;
                    for (Module module : app.getModules()) {
                        webModule = module.getWeb();
                        if (webModule == null) continue;
                        uri = webModule.getWebUri();
                        contextRoot = webModule.getContextRoot();
                        if (uri == null || contextRoot == null) continue;
                        webModuleUriToContextRoot.put(uri, contextRoot);
                    }
                } else if (model instanceof Application) {
                    app = (Application)model;
                    for (Module module : app.getModules()) {
                        if (!module.isWebModule()) continue;
                        webModule = (WebModule)module;
                        uri = webModule.getUri();
                        contextRoot = webModule.getContextRoot();
                        if (uri == null || contextRoot == null) continue;
                        webModuleUriToContextRoot.put(uri, contextRoot);
                    }
                } else {
                    throw new IllegalStateException();
                }
            }
            if ((earComp = ComponentCore.createComponent((IProject)project)) != null) {
                IVirtualReference[] iVirtualReferenceArray = earComp.getReferences();
                int n = iVirtualReferenceArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IVirtualReference ref = iVirtualReferenceArray[n2];
                    String archiveName = ref.getArchiveName();
                    contextRoot = (String)webModuleUriToContextRoot.get(archiveName);
                    if (contextRoot != null) {
                        ContextRootSource source = new ContextRootSource(ContextRootSourceType.PROJECT, ref.getReferencedComponent().getProject());
                        LibraryContextRootOverridesValidator.addToResult(result, contextRoot, source);
                    }
                    ++n2;
                }
            }
        }
        return result;
    }

    private static void addToResult(Map<String, Set<ContextRootSource>> result, String contextRoot, ContextRootSource source) {
        Set<ContextRootSource> sources = result.get(contextRoot);
        if (sources == null) {
            sources = new HashSet<ContextRootSource>();
            result.put(contextRoot, sources);
        }
        sources.add(source);
    }

    private static Set<String> getLibraryContextRoots(IWebLogicAppDescriptor descriptor) {
        TreeSet<String> result = new TreeSet<String>();
        for (ILibraryRef libref : descriptor.getLibraryRefs()) {
            LibraryModule lib;
            try {
                lib = LibraryModulesSvc.resolve(LibraryModulesSvc.convert(libref));
            }
            catch (CoreException coreException) {
                continue;
            }
            LibraryModule.Type type = lib.getType();
            if (type == LibraryModule.Type.EAR) {
                try {
                    File tempExplodedRoot = lib.explode();
                    File applicationXmlFile = new File(tempExplodedRoot, "META-INF/application.xml");
                    if (applicationXmlFile.exists()) {
                        Element root = DomUtil.root((File)applicationXmlFile);
                        if (root == null) continue;
                        for (Element module : DomUtil.elements((Element)root, (String)EL_MODULE)) {
                            String contextRoot;
                            Element webModule = DomUtil.element((Element)module, (String)EL_WEB);
                            if (webModule == null || (contextRoot = DomUtil.text((Element)webModule, (String)EL_CONTEXT_ROOT)) == null || contextRoot.length() <= 0) continue;
                            result.add(contextRoot);
                        }
                        continue;
                    }
                    File[] fileArray = tempExplodedRoot.listFiles();
                    int n = fileArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String fname;
                        File f = fileArray[n2];
                        if (f.isFile() && (fname = f.getName()).toLowerCase().endsWith(".war") && fname.length() > 4) {
                            result.add(fname.substring(0, fname.length() - 4));
                        }
                        ++n2;
                    }
                }
                catch (IOException e) {
                    WlsCorePlugin.logException(e);
                }
                continue;
            }
            if (type != LibraryModule.Type.WAR) continue;
            String contextRoot = libref.getContextRoot().text();
            if (contextRoot == null) {
                String fname = lib.getLocation().getName();
                contextRoot = fname.toLowerCase().endsWith(".war") && fname.length() > 4 ? fname.substring(0, fname.length() - 4) : fname;
            }
            result.add(contextRoot);
        }
        return result;
    }

    private static final class ContextRootSource {
        public ContextRootSourceType type;
        public Object data;

        public ContextRootSource(ContextRootSourceType type, Object data) {
            this.type = type;
            this.data = data;
        }
    }

    private static enum ContextRootSourceType {
        PROJECT,
        LIBRARY,
        LIBRARY_OVERRIDE;

    }

    private static final class Resources
    extends NLS {
        public static String libraryContextRootSpecifiedMoreThanOnce;
        public static String noChangeOverride;
        public static String overrideCollisionWithProject;
        public static String overrideCollisionWithLibrary;
        public static String overrideCollesionWithLibraryOverride;

        static {
            Resources.initializeMessages((String)LibraryContextRootOverridesValidator.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

