/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.descriptors.internal;

import oracle.eclipse.tools.weblogic.descriptors.IApplicationParam;
import oracle.eclipse.tools.weblogic.descriptors.IWebLogicAppDescriptor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.ElementList;
import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.PropertyContentEvent;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.services.ValidationService;

public final class ApplicationParamNameValidator
extends ValidationService {
    private Listener listener;

    protected void initValidationService() {
        this.listener = new FilteredListener<PropertyContentEvent>(){

            protected void handleTypedEvent(PropertyContentEvent event) {
                ApplicationParamNameValidator.this.refresh();
            }
        };
        IWebLogicAppDescriptor descriptor = (IWebLogicAppDescriptor)this.context(IWebLogicAppDescriptor.class);
        descriptor.attach(this.listener, "ApplicationParams/Name");
        descriptor.attach(this.listener, "ApplicationParams/Value");
    }

    protected Status compute() {
        Value value = (Value)this.context(Value.class);
        String paramName = value.text();
        if (paramName != null && paramName.equals("webapp.encoding.default")) {
            ElementList params = (ElementList)value.element().parent();
            for (Element p : params) {
                IApplicationParam param = (IApplicationParam)p;
                String pName = param.getName().text();
                String pValue = param.getValue().text();
                if (pName == null || !pName.equals("webapp.encoding.usevmdefault") || pValue == null || !Boolean.parseBoolean(pValue)) continue;
                return Status.createStatus((Status.Severity)Status.Severity.WARNING, (String)Resources.vmDefaultOverrides);
            }
        }
        return Status.createOkStatus();
    }

    public void dispose() {
        super.dispose();
        if (this.listener != null) {
            IWebLogicAppDescriptor descriptor = (IWebLogicAppDescriptor)this.context(IWebLogicAppDescriptor.class);
            descriptor.detach(this.listener, "ApplicationParams/Name");
            descriptor.detach(this.listener, "ApplicationParams/Value");
            this.listener = null;
        }
    }

    private static final class Resources
    extends NLS {
        public static String vmDefaultOverrides;

        static {
            Resources.initializeMessages((String)ApplicationParamNameValidator.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

