/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.descriptors.ejbjar.internal;

import java.util.Set;
import oracle.eclipse.tools.weblogic.descriptors.ejbjar.IPersistenceUse;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.PropertyContentEvent;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.services.PossibleValuesService;

public class PersistenceUseTypeVersionValuesProvider
extends PossibleValuesService {
    private Listener listener;

    protected void init() {
        super.init();
        this.listener = new FilteredListener<PropertyContentEvent>(){

            protected void handleTypedEvent(PropertyContentEvent event) {
                PersistenceUseTypeVersionValuesProvider.this.broadcast();
            }
        };
        IPersistenceUse persistenceUse = (IPersistenceUse)this.context(IPersistenceUse.class);
        if (persistenceUse != null) {
            persistenceUse.getTypeIdentifier().attach(this.listener);
        }
    }

    public void dispose() {
        super.dispose();
        IPersistenceUse persistenceUse = (IPersistenceUse)this.context(IPersistenceUse.class);
        if (persistenceUse != null && !persistenceUse.disposed()) {
            persistenceUse.getTypeIdentifier().detach(this.listener);
        }
    }

    protected void fillPossibleValues(Set<String> values) {
        if (this.isWebLogicCmpRdbms(this.context(Element.class))) {
            values.add("6.0");
            values.add("5.1.0");
        }
    }

    private boolean isWebLogicCmpRdbms(Object model) {
        IPersistenceUse pUse = (IPersistenceUse)model;
        return "WebLogic_CMP_RDBMS".equals(pUse.getTypeIdentifier().text());
    }

    public Status.Severity getInvalidValueSeverity(String invalidValue) {
        if (this.isWebLogicCmpRdbms(this.context(Element.class))) {
            return Status.Severity.ERROR;
        }
        return Status.Severity.OK;
    }

    public String getInvalidValueMessage(String invalidValue) {
        if (this.isWebLogicCmpRdbms(this.context(Element.class))) {
            return Resources.bind((String)Resources.invalidValueMessage, (Object)invalidValue);
        }
        return "";
    }

    private static final class Resources
    extends NLS {
        public static String invalidValueMessage;

        static {
            Resources.initializeMessages((String)PersistenceUseTypeVersionValuesProvider.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

