/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.descriptors.ejbjar.internal;

import java.util.ArrayList;
import java.util.List;
import oracle.eclipse.tools.common.util.StringUtil;
import org.eclipse.sapphire.modeling.xml.XmlElement;
import org.eclipse.sapphire.modeling.xml.XmlValueBindingImpl;

public class MethodNameBinding
extends XmlValueBindingImpl {
    private static final String METHOD_NAME = "method-name";
    private static final String METHOD_PARAMS = "method-params";
    private static final String METHOD_PARAM = "method-param";

    public String read() {
        XmlElement name;
        ArrayList<String> paramList = new ArrayList<String>();
        XmlElement el = this.xml(false);
        XmlElement xmlElement = name = el != null ? el.getChildElement(METHOD_NAME, false) : null;
        if (name != null) {
            String nameStr = name.getText();
            if (nameStr == null || nameStr.length() == 0 || "*".equals(nameStr)) {
                return nameStr;
            }
            StringBuffer buf = new StringBuffer();
            buf.append(nameStr);
            buf.append("(");
            XmlElement params = el.getChildElement(METHOD_PARAMS, false);
            if (params != null) {
                for (XmlElement param : params.getChildElements(METHOD_PARAM)) {
                    paramList.add(param.getText());
                }
                buf.append(StringUtil.join(paramList, (char)','));
            }
            buf.append(")");
            return buf.toString();
        }
        return null;
    }

    public void write(String value) {
        XmlElement el = this.xml(true);
        if (el != null) {
            int index2;
            int index = value == null ? -1 : value.indexOf(40);
            int n = index2 = value == null ? -1 : value.indexOf(41);
            if (index > 0 && index2 > 0 && index2 > index) {
                String nameStr = value.substring(0, index);
                String paramsStr = value.substring(index + 1, index2);
                XmlElement name = el.getChildElement(METHOD_NAME, true);
                name.setText(nameStr);
                List paramList = StringUtil.split((String)paramsStr, (char)',');
                XmlElement params = el.getChildElement(METHOD_PARAMS, false);
                if (params != null) {
                    params.remove();
                }
                if (!paramList.isEmpty()) {
                    XmlElement newParams = el.getChildElement(METHOD_PARAMS, true);
                    for (String param : paramList) {
                        XmlElement child = newParams.addChildElement(METHOD_PARAM);
                        child.setText(param);
                    }
                }
            } else {
                XmlElement params;
                XmlElement name;
                if (value == null || value.length() == 0) {
                    name = el.getChildElement(METHOD_NAME, false);
                    if (name != null) {
                        name.remove();
                    }
                } else {
                    name = el.getChildElement(METHOD_NAME, true);
                    if (name != null) {
                        name.setText(value);
                    }
                }
                if ((params = el.getChildElement(METHOD_PARAMS, false)) != null) {
                    params.remove();
                }
            }
        }
    }
}

