/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.descriptors.ejbjar.internal;

import java.util.ArrayList;
import oracle.eclipse.tools.weblogic.descriptors.IWebLogicEjbModuleDescriptor;
import oracle.eclipse.tools.weblogic.descriptors.ejbjar.IEntityDescriptor;
import oracle.eclipse.tools.weblogic.descriptors.ejbjar.IMessageDriven;
import oracle.eclipse.tools.weblogic.descriptors.ejbjar.ISingletonSession;
import oracle.eclipse.tools.weblogic.descriptors.ejbjar.IStatefulSession;
import oracle.eclipse.tools.weblogic.descriptors.ejbjar.IStatelessSession;
import org.eclipse.core.resources.IProject;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.ElementType;
import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.PropertyContentEvent;
import org.eclipse.sapphire.Version;
import org.eclipse.sapphire.services.PossibleTypesService;
import org.eclipse.sapphire.services.PossibleTypesServiceData;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;

public final class EjbsPossibleTypesService
extends PossibleTypesService {
    private static final IProjectFacet EJB_FACET = ProjectFacetsManager.getProjectFacet((String)"jst.ejb");
    private Listener listener;

    protected void initPossibleTypesService() {
        this.listener = new FilteredListener<PropertyContentEvent>(){

            protected void handleTypedEvent(PropertyContentEvent event) {
                EjbsPossibleTypesService.this.refresh();
            }
        };
        ((IWebLogicEjbModuleDescriptor)this.context(IWebLogicEjbModuleDescriptor.class)).getServerVersion().attach(this.listener);
    }

    protected PossibleTypesServiceData compute() {
        ArrayList<ElementType> types = new ArrayList<ElementType>();
        types.add(IEntityDescriptor.TYPE);
        types.add(IStatelessSession.TYPE);
        types.add(IStatefulSession.TYPE);
        types.add(IMessageDriven.TYPE);
        IWebLogicEjbModuleDescriptor descriptor = (IWebLogicEjbModuleDescriptor)this.context(IWebLogicEjbModuleDescriptor.class);
        Version version = (Version)descriptor.getServerVersion().content();
        boolean isEjb31 = false;
        try {
            IProject project = (IProject)((Element)this.context(Element.class)).adapt(IProject.class);
            IFacetedProject fproj = ProjectFacetsManager.create((IProject)project);
            if (fproj != null) {
                IProjectFacetVersion ejbFacetVersion = fproj.getInstalledVersion(EJB_FACET);
                String x = ejbFacetVersion.getVersionString();
                isEjb31 = x.compareTo("3.1") >= 0;
            }
        }
        catch (Exception exception) {}
        if (version != null && version.matches("[12.1.1") && isEjb31) {
            types.add(ISingletonSession.TYPE);
        }
        return new PossibleTypesServiceData(types);
    }

    public void dispose() {
        if (this.listener != null) {
            IWebLogicEjbModuleDescriptor descriptor = (IWebLogicEjbModuleDescriptor)this.context(IWebLogicEjbModuleDescriptor.class);
            if (descriptor != null && !descriptor.disposed()) {
                descriptor.getServerVersion().detach(this.listener);
            }
            this.listener = null;
        }
        super.dispose();
    }
}

