/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.descriptors.ejbjar.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import oracle.eclipse.tools.weblogic.descriptors.ejbjar.IEntityDescriptor;
import oracle.eclipse.tools.weblogic.descriptors.ejbjar.IMessageDriven;
import oracle.eclipse.tools.weblogic.descriptors.ejbjar.ISingletonSession;
import oracle.eclipse.tools.weblogic.descriptors.ejbjar.IStatefulSession;
import oracle.eclipse.tools.weblogic.descriptors.ejbjar.IStatelessSession;
import oracle.eclipse.tools.weblogic.descriptors.ejbjar.internal.BaseEjbJarValuesProvider;
import org.eclipse.jst.j2ee.ejb.EnterpriseBean;
import org.eclipse.jst.j2ee.ejb.Session;
import org.eclipse.jst.javaee.ejb.EJBJar;
import org.eclipse.jst.javaee.ejb.EnterpriseBeans;
import org.eclipse.jst.javaee.ejb.EntityBean;
import org.eclipse.jst.javaee.ejb.MessageDrivenBean;
import org.eclipse.jst.javaee.ejb.SessionBean;
import org.eclipse.jst.javaee.ejb.SessionType;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.ElementType;

public final class EjbNameValuesProvider
extends BaseEjbJarValuesProvider {
    protected void fillPossibleValues(Set<String> values) {
        values.addAll(EjbNameValuesProvider.getValues((Element)this.context(Element.class), true));
    }

    public static List<String> getValues(Element element, boolean includeUnset) {
        EJBJar ejbjar;
        EnterpriseBeans beans;
        ArrayList<String> result = new ArrayList<String>();
        Object model = EjbNameValuesProvider.getModel(element);
        if (model instanceof org.eclipse.jst.j2ee.ejb.EJBJar) {
            org.eclipse.jst.j2ee.ejb.EJBJar ejbjar2 = (org.eclipse.jst.j2ee.ejb.EJBJar)model;
            for (Object obj : ejbjar2.getEnterpriseBeans()) {
                EnterpriseBean bean = (EnterpriseBean)obj;
                result.add(bean.getName());
            }
        } else if (model instanceof EJBJar && (beans = (ejbjar = (EJBJar)model).getEnterpriseBeans()) != null) {
            for (Object obj : beans.getEntityBeans()) {
                EntityBean entityBean = (EntityBean)obj;
                result.add(entityBean.getEjbName());
            }
            for (Object obj : beans.getSessionBeans()) {
                SessionBean sessionBean = (SessionBean)obj;
                boolean isSet = sessionBean.isSetSessionType();
                if (!includeUnset && !isSet) continue;
                result.add(sessionBean.getEjbName());
            }
            for (Object obj : beans.getMessageDrivenBeans()) {
                MessageDrivenBean MDBean = (MessageDrivenBean)obj;
                result.add(MDBean.getEjbName());
            }
        }
        Collections.sort(result);
        return result;
    }

    public static ElementType getElementType(Object section, String ejbName) {
        block13: {
            EJBJar ejbjar;
            EnterpriseBeans beans;
            Object model;
            block12: {
                model = EjbNameValuesProvider.getModel(section);
                if (!(model instanceof org.eclipse.jst.j2ee.ejb.EJBJar)) break block12;
                org.eclipse.jst.j2ee.ejb.EJBJar ejbjar2 = (org.eclipse.jst.j2ee.ejb.EJBJar)model;
                for (Object obj : ejbjar2.getEnterpriseBeans()) {
                    EnterpriseBean bean = (EnterpriseBean)obj;
                    if (!ejbName.equals(bean.getName())) continue;
                    if (bean.isEntity()) {
                        return ElementType.read(IEntityDescriptor.class);
                    }
                    if (bean.isMessageDriven()) {
                        return ElementType.read(IMessageDriven.class);
                    }
                    if (bean.isSession()) {
                        Iterator iterator = ejbjar2.getSessionBeans().iterator();
                        if (!iterator.hasNext()) continue;
                        Object obj2 = iterator.next();
                        Session sessionBean = (Session)obj2;
                        if (org.eclipse.jst.j2ee.ejb.SessionType.STATEFUL_LITERAL.equals(sessionBean.getSessionType())) {
                            return ElementType.read(IStatefulSession.class);
                        }
                        if (org.eclipse.jst.j2ee.ejb.SessionType.SINGLETON_LITERAL.equals(sessionBean.getSessionType())) {
                            return ElementType.read(ISingletonSession.class);
                        }
                        return ElementType.read(IStatelessSession.class);
                    }
                    assert (false);
                }
                break block13;
            }
            if (!(model instanceof EJBJar) || (beans = (ejbjar = (EJBJar)model).getEnterpriseBeans()) == null) break block13;
            for (Object obj : beans.getEntityBeans()) {
                EntityBean entityBean = (EntityBean)obj;
                if (!ejbName.equals(entityBean.getEjbName())) continue;
                return ElementType.read(IEntityDescriptor.class);
            }
            for (Object obj : beans.getSessionBeans()) {
                SessionBean sessionBean = (SessionBean)obj;
                if (!ejbName.equals(sessionBean.getEjbName())) continue;
                boolean isSet = sessionBean.isSetSessionType();
                if (SessionType.STATEFUL_LITERAL.equals((Object)sessionBean.getSessionType()) && isSet) {
                    return ElementType.read(IStatefulSession.class);
                }
                if (SessionType.SINGLETON_LITERAL.equals((Object)sessionBean.getSessionType()) && isSet) {
                    return ElementType.read(ISingletonSession.class);
                }
                return ElementType.read(IStatelessSession.class);
            }
            for (Object obj : beans.getMessageDrivenBeans()) {
                MessageDrivenBean MDBean = (MessageDrivenBean)obj;
                if (!ejbName.equals(MDBean.getEjbName())) continue;
                return ElementType.read(IMessageDriven.class);
            }
        }
        return null;
    }
}

