/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.descriptors.ejbjar;

import oracle.eclipse.tools.weblogic.descriptors.ejbjar.IClustering;
import oracle.eclipse.tools.weblogic.descriptors.ejbjar.LoadAlgorithm;
import org.eclipse.sapphire.ElementType;
import org.eclipse.sapphire.ReferenceValue;
import org.eclipse.sapphire.Since;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.ValueProperty;
import org.eclipse.sapphire.java.JavaType;
import org.eclipse.sapphire.java.JavaTypeConstraint;
import org.eclipse.sapphire.java.JavaTypeKind;
import org.eclipse.sapphire.java.JavaTypeName;
import org.eclipse.sapphire.modeling.annotations.DefaultValue;
import org.eclipse.sapphire.modeling.annotations.Documentation;
import org.eclipse.sapphire.modeling.annotations.Enablement;
import org.eclipse.sapphire.modeling.annotations.Label;
import org.eclipse.sapphire.modeling.annotations.MustExist;
import org.eclipse.sapphire.modeling.annotations.Reference;
import org.eclipse.sapphire.modeling.annotations.Type;
import org.eclipse.sapphire.modeling.xml.annotations.XmlBinding;

public interface ISingletonClustering
extends IClustering {
    public static final ElementType TYPE = new ElementType(ISingletonClustering.class);
    @Type(base=Boolean.class)
    @XmlBinding(path="use-serverside-stubs")
    @Label(standard="use serverside stubs")
    @DefaultValue(text="false")
    @Since(value="12.1.1")
    @Documentation(content="Causes the bean home to use server-side stubs in the context of server.")
    public static final ValueProperty PROP_USE_SERVERSIDE_STUBS = new ValueProperty(TYPE, "UseServersideStubs");
    @Type(base=Boolean.class)
    @XmlBinding(path="singleton-bean-is-clusterable")
    @Label(standard="singleton bean is clusterable")
    @DefaultValue(text="true")
    @Since(value="12.1.1")
    @Documentation(content="When set to \"true\", the EJB can be deployed from multiple Oracle WebLogic Servers in a cluster.")
    public static final ValueProperty PROP_SINGLETON_BEAN_IS_CLUSTERABLE = new ValueProperty(TYPE, "SingletonBeanIsClusterable");
    @Type(base=LoadAlgorithm.class)
    @XmlBinding(path="singleton-bean-load-algorithm")
    @Label(standard="singleton bean load algorithm")
    @DefaultValue(text="round-robin")
    @Since(value="12.1.1")
    @Enablement(expr="${ SingletonBeanIsClusterable }")
    @Documentation(content="Specifies the algorithm to use for load balancing.[ul][li]round-robin: Load balancing is performed in a sequential fashion among the servers hosting the bean.[/li][li]random: Replicas of the EJB home are deployed randomly among the servers hosting the bean.[/li][li]weight-based: Replicas of the EJB home are deployed on host servers according to the servers\u2019 current workload.[/li][li]round-robin-affinity: Server affinity governs connections between external Java clients and server instances; round robin load balancing is used for connections between server instances.[/li][li]weight-based-affinity: Server affinity governs connections between external Java clients and server instances; weight-based load balancing is used for connections between server instances.[/li][li]random-affinity: Server affinity governs connections between external Java clients and server instances; random load balancing is used for connections between server instances.[/li][/ul]")
    public static final ValueProperty PROP_SINGLETON_BEAN_LOAD_ALGORITHM = new ValueProperty(TYPE, "SingletonBeanLoadAlgorithm");
    @Type(base=JavaTypeName.class)
    @Reference(target=JavaType.class)
    @XmlBinding(path="singleton-bean-call-router-class-name")
    @Label(standard="singleton bean call router")
    @JavaTypeConstraint(kind={JavaTypeKind.CLASS}, type={"weblogic.rmi.cluster.CallRouter"})
    @MustExist
    @Since(value="12.1.1")
    @Enablement(expr="${ SingletonBeanIsClusterable }")
    @Documentation(content="Specifies the name of a custom class to use for routing bean method calls.")
    public static final ValueProperty PROP_SINGLETON_BEAN_CALL_ROUTER_CLASS_NAME = new ValueProperty(TYPE, "SingletonBeanCallRouterClassName");

    @Override
    public Value<Boolean> getUseServersideStubs();

    @Override
    public void setUseServersideStubs(String var1);

    @Override
    public void setUseServersideStubs(Boolean var1);

    public Value<Boolean> getSingletonBeanIsClusterable();

    public void setSingletonBeanIsClusterable(String var1);

    public void setSingletonBeanIsClusterable(Boolean var1);

    public Value<LoadAlgorithm> getSingletonBeanLoadAlgorithm();

    public void setSingletonBeanLoadAlgorithm(String var1);

    public void setSingletonBeanLoadAlgorithm(LoadAlgorithm var1);

    public ReferenceValue<JavaTypeName, JavaType> getSingletonBeanCallRouterClassName();

    public void setSingletonBeanCallRouterClassName(String var1);

    public void setSingletonBeanCallRouterClassName(JavaTypeName var1);
}

