/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.descriptors.ejbjar;

import oracle.eclipse.tools.weblogic.descriptors.ejbjar.DistributedDestinationConnection;
import oracle.eclipse.tools.weblogic.descriptors.ejbjar.IPool;
import oracle.eclipse.tools.weblogic.descriptors.ejbjar.ISecurityPlugin;
import oracle.eclipse.tools.weblogic.descriptors.ejbjar.ITimerDescriptor;
import oracle.eclipse.tools.weblogic.descriptors.ejbjar.IWeblogicEnterpriseBean;
import oracle.eclipse.tools.weblogic.descriptors.ejbjar.MessageDrivenOptions;
import oracle.eclipse.tools.weblogic.descriptors.ejbjar.internal.EjbNameMessageDrivenValuesProvider;
import oracle.eclipse.tools.weblogic.descriptors.ejbjar.internal.MessageDrivenOptionsBinding;
import org.eclipse.sapphire.ElementHandle;
import org.eclipse.sapphire.ElementProperty;
import org.eclipse.sapphire.ElementType;
import org.eclipse.sapphire.ReferenceValue;
import org.eclipse.sapphire.Since;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.ValueProperty;
import org.eclipse.sapphire.java.JavaType;
import org.eclipse.sapphire.java.JavaTypeConstraint;
import org.eclipse.sapphire.java.JavaTypeKind;
import org.eclipse.sapphire.java.JavaTypeName;
import org.eclipse.sapphire.modeling.annotations.DefaultValue;
import org.eclipse.sapphire.modeling.annotations.Documentation;
import org.eclipse.sapphire.modeling.annotations.Image;
import org.eclipse.sapphire.modeling.annotations.Label;
import org.eclipse.sapphire.modeling.annotations.MustExist;
import org.eclipse.sapphire.modeling.annotations.NumericRange;
import org.eclipse.sapphire.modeling.annotations.Reference;
import org.eclipse.sapphire.modeling.annotations.Service;
import org.eclipse.sapphire.modeling.annotations.Type;
import org.eclipse.sapphire.modeling.xml.annotations.CustomXmlValueBinding;
import org.eclipse.sapphire.modeling.xml.annotations.XmlBinding;

@Label(standard="message driven bean")
@Image(path="images/descriptors/ejb/mssg-driven-bean.png")
public interface IMessageDriven
extends IWeblogicEnterpriseBean,
IPool,
ITimerDescriptor {
    public static final ElementType TYPE = new ElementType(IMessageDriven.class);
    @Service(impl=EjbNameMessageDrivenValuesProvider.class)
    public static final ValueProperty PROP_EJB_NAME = new ValueProperty(TYPE, IWeblogicEnterpriseBean.PROP_EJB_NAME);
    @XmlBinding(path="message-driven-descriptor/pool/max-beans-in-free-pool")
    public static final ValueProperty PROP_MAX_BEANS_IN_FREE_POOL = new ValueProperty(TYPE, IPool.PROP_MAX_BEANS_IN_FREE_POOL);
    @XmlBinding(path="message-driven-descriptor/pool/initial-beans-in-free-pool")
    public static final ValueProperty PROP_INITIAL_BEANS_IN_FREE_POOL = new ValueProperty(TYPE, IPool.PROP_INITIAL_BEANS_IN_FREE_POOL);
    @XmlBinding(path="message-driven-descriptor/pool/idle-timeout-seconds")
    public static final ValueProperty PROP_IDLE_TIMEOUT_SECONDS = new ValueProperty(TYPE, IPool.PROP_IDLE_TIMEOUT_SECONDS);
    @XmlBinding(path="message-driven-descriptor/timer-descriptor/persistent-store-logical-name")
    public static final ValueProperty PROP_PERSISTENT_STORE_LOGICAL_NAME = new ValueProperty(TYPE, ITimerDescriptor.PROP_PERSISTENT_STORE_LOGICAL_NAME);
    @Type(base=Integer.class)
    @XmlBinding(path="message-driven-descriptor/init-suspend-seconds")
    @Label(standard="initial suspend time (secs)")
    @NumericRange(min="1")
    @DefaultValue(text="60")
    @Documentation(content="Specifies the initial number of seconds to suspend an MDB\u2019s JMS connection when the EJB container detects a JMS resource outage.")
    public static final ValueProperty PROP_INIT_SUSPEND_SECONDS = new ValueProperty(TYPE, "InitSuspendSeconds");
    @Type(base=Integer.class)
    @XmlBinding(path="message-driven-descriptor/max-suspend-seconds")
    @Label(standard="maximum suspend time (secs)")
    @NumericRange(min="0")
    @DefaultValue(text="60")
    @Documentation(content="Specifies the maximum number of seconds to suspend an MDB\u2019s JMS connection when the EJB container detects a JMS resource outage.")
    public static final ValueProperty PROP_MAX_SUSPEND_SECONDS = new ValueProperty(TYPE, "MaxSuspendSeconds");
    @Type(base=ISecurityPlugin.class)
    @XmlBinding(path="message-driven-descriptor/security-plugin")
    @Documentation(content="At runtime, the security plugin class will be instantiated by the container and will be invoked to get the credentials for connecting to a secure JMS destination.")
    public static final ElementProperty PROP_SECURITY_PLUGIN = new ElementProperty(TYPE, "SecurityPlugin");
    @Type(base=MessageDrivenOptions.class)
    @CustomXmlValueBinding(impl=MessageDrivenOptionsBinding.class)
    @Label(standard="message driven bean options")
    @DefaultValue(text="DESTINATION_JNDI")
    public static final ValueProperty PROP_MESSAGE_DRIVEN_OPTIONS = new ValueProperty(TYPE, "MessageDrivenOptions");
    @XmlBinding(path="message-driven-descriptor/destination-jndi-name")
    @Label(standard="destination JNDI name")
    @Documentation(content="Specifies the JNDI name used to associate a message-driven bean with an actual JMS Queue or Topic deployed in the Oracle WebLogic Server JNDI tree.")
    public static final ValueProperty PROP_DESTINATION_JNDI_NAME = new ValueProperty(TYPE, "DestinationJndiName");
    @Type(base=JavaTypeName.class)
    @Reference(target=JavaType.class)
    @XmlBinding(path="message-driven-descriptor/initial-context-factory")
    @Label(standard="initial context factory")
    @DefaultValue(text="weblogic.jndi.WLInitialContextFactory")
    @JavaTypeConstraint(kind={JavaTypeKind.CLASS}, type={"javax.naming.spi.InitialContextFactory"})
    @MustExist
    @Documentation(content="Specifies the initial context factory used by the JMS provider to create initial context.")
    public static final ValueProperty PROP_INITIAL_CONTEXT_FACTORY = new ValueProperty(TYPE, "InitialContextFactory");
    @XmlBinding(path="message-driven-descriptor/provider-url")
    @Label(standard="provider URL")
    @DefaultValue(text="t3://localhost:7001")
    @Documentation(content="Specifies the URL to be used by the InitialContext.")
    public static final ValueProperty PROP_PROVIDER_URL = new ValueProperty(TYPE, "ProviderUrl");
    @XmlBinding(path="message-driven-descriptor/connection-factory-jndi-name")
    @Label(standard="connection factory JNDI name")
    @DefaultValue(text="weblogic.jms.MessageDrivenBeanConnectionFactory")
    @Documentation(content="Specifies the JNDI name of the JMS Connection Factory that a message-driven bean looks up to create its queues and topics. The default weblogic.jms.MessageDrivenBeanConnectionFactory must have been declared in the JMSConnectionFactory element in the config.xml file.")
    public static final ValueProperty PROP_CONNECTION_FACTORY_JNDI_NAME = new ValueProperty(TYPE, "ConnectionFactoryJndiName");
    @XmlBinding(path="message-driven-descriptor/destination-resource-link")
    @Label(standard="destination resource link")
    @Documentation(content="Maps to a resource within a JMS module defined in the ejb-jar.xml file to an actual JMS Module Reference in Oracle WebLogic Server.")
    public static final ValueProperty PROP_DESTINATION_RESOURCE_LINK = new ValueProperty(TYPE, "DestinationResourceLink");
    @XmlBinding(path="message-driven-descriptor/connection-factory-resource-link")
    @Label(standard="connection factory resource link")
    @Documentation(content="Maps to a resource within a JMS module defined in the ejb-jar.xml file to an actual JMS Module Reference in Oracle WebLogic Server.")
    public static final ValueProperty PROP_CONNECTION_FACTORY_RESOURCE_LINK = new ValueProperty(TYPE, "ConnectionFactoryResourceLink");
    @Type(base=Integer.class)
    @XmlBinding(path="message-driven-descriptor/jms-polling-interval-seconds")
    @Label(standard="JMS polling interval (secs)")
    @NumericRange(min="0")
    @DefaultValue(text="10")
    @Documentation(content="Specifies the number of seconds between each attempt to reconnect to the JMS destination.")
    public static final ValueProperty PROP_JMS_POLLING_INTERVAL_SECONDS = new ValueProperty(TYPE, "JmsPollingIntervalSeconds");
    @XmlBinding(path="message-driven-descriptor/jms-client-id")
    @Label(standard="JMS client")
    @DefaultValue(text="${ EjbName }")
    @Documentation(content="Specifies a client ID for the MDB when it connects to a JMS destination.")
    public static final ValueProperty PROP_JMS_CLIENT_ID = new ValueProperty(TYPE, "JmsClientId");
    @Type(base=Boolean.class)
    @XmlBinding(path="message-driven-descriptor/generate-unique-jms-client-id")
    @Label(standard="generate unique JMS client-id")
    @DefaultValue(text="false")
    @Documentation(content="Indicates whether or not you want the EJB container to generate a unique client-id for every instance of an MDB.")
    public static final ValueProperty PROP_GENERATE_UNIQUE_JMS_CLIENT_ID = new ValueProperty(TYPE, "GenerateUniqueJmsClientId");
    @Type(base=Boolean.class)
    @XmlBinding(path="message-driven-descriptor/durable-subscription-deletion")
    @Label(standard="delete durable subscription")
    @DefaultValue(text="false")
    @Documentation(content="Indicates whether or not you want durable topic subscriptions to be automatically deleted when an MDB is undeployed or removed.")
    public static final ValueProperty PROP_DURABLE_SUBSCRIPTION_DELETION = new ValueProperty(TYPE, "DurableSubscriptionDeletion");
    @Type(base=Integer.class)
    @XmlBinding(path="message-driven-descriptor/max-messages-in-transaction")
    @Label(standard="maximum messages in transaction")
    @NumericRange(min="1")
    @DefaultValue(text="1")
    @Documentation(content="Specifies the maximum number of messages that can be in a transaction for this MDB.")
    public static final ValueProperty PROP_MAX_MESSAGES_IN_TRANSACTION = new ValueProperty(TYPE, "MaxMessagesInTransaction");
    @Type(base=DistributedDestinationConnection.class)
    @XmlBinding(path="message-driven-descriptor/distributed-destination-connection")
    @Label(standard="distributed destination connection")
    @DefaultValue(text="LocalOnly")
    @Documentation(content="Specifies whether or not an MDB that accesses a WebLogic JMS distributed queue in the same cluster consumes from all distributed destination members, or only those members local to the current Oracle Weblogic Server.[ul][li]LocalOnly: Deployment descriptor and message-driven bean are in the same cluster.[/li][li]EveryMember: Deployment descriptor is on a remote server.[/li][/ul]")
    public static final ValueProperty PROP_DISTRIBUTED_DESTINATION_CONNECTION = new ValueProperty(TYPE, "DistributedDestinationConnection");
    @Type(base=Boolean.class)
    @XmlBinding(path="message-driven-descriptor/use81-style-polling")
    @Label(standard="enables WLS 8.1 style polling")
    @DefaultValue(text="false")
    @Since(value="10.3")
    @Documentation(content="Enables backwards compatibility for WebLogic Server version 8.1-style polling.")
    public static final ValueProperty PROP_USE81_STYLE_POLLING = new ValueProperty(TYPE, "Use81StylePolling");
    @XmlBinding(path="message-driven-descriptor/resource-adapter-jndi-name")
    @Label(standard="resource adapter jndi name")
    @Documentation(content="Identifies the resource adapter from which this message-driven bean receives messages.")
    public static final ValueProperty PROP_RESOURCE_ADAPTER_JNDI_NAME = new ValueProperty(TYPE, "ResourceAdapterJndiName");

    public Value<Integer> getInitSuspendSeconds();

    public void setInitSuspendSeconds(String var1);

    public void setInitSuspendSeconds(Integer var1);

    public Value<Integer> getMaxSuspendSeconds();

    public void setMaxSuspendSeconds(String var1);

    public void setMaxSuspendSeconds(Integer var1);

    public ElementHandle<ISecurityPlugin> getSecurityPlugin();

    public Value<MessageDrivenOptions> getMessageDrivenOptions();

    public void setMessageDrivenOptions(String var1);

    public void setMessageDrivenOptions(MessageDrivenOptions var1);

    public Value<String> getDestinationJndiName();

    public void setDestinationJndiName(String var1);

    public ReferenceValue<JavaTypeName, JavaType> getInitialContextFactory();

    public void setInitialContextFactory(String var1);

    public void setInitialContextFactory(JavaTypeName var1);

    public Value<String> getProviderUrl();

    public void setProviderUrl(String var1);

    public Value<String> getConnectionFactoryJndiName();

    public void setConnectionFactoryJndiName(String var1);

    public Value<String> getDestinationResourceLink();

    public void setDestinationResourceLink(String var1);

    public Value<String> getConnectionFactoryResourceLink();

    public void setConnectionFactoryResourceLink(String var1);

    public Value<Integer> getJmsPollingIntervalSeconds();

    public void setJmsPollingIntervalSeconds(String var1);

    public void setJmsPollingIntervalSeconds(Integer var1);

    public Value<String> getJmsClientId();

    public void setJmsClientId(String var1);

    public Value<Boolean> getGenerateUniqueJmsClientId();

    public void setGenerateUniqueJmsClientId(String var1);

    public void setGenerateUniqueJmsClientId(Boolean var1);

    public Value<Boolean> getDurableSubscriptionDeletion();

    public void setDurableSubscriptionDeletion(String var1);

    public void setDurableSubscriptionDeletion(Boolean var1);

    public Value<Integer> getMaxMessagesInTransaction();

    public void setMaxMessagesInTransaction(String var1);

    public void setMaxMessagesInTransaction(Integer var1);

    public Value<DistributedDestinationConnection> getDistributedDestinationConnection();

    public void setDistributedDestinationConnection(String var1);

    public void setDistributedDestinationConnection(DistributedDestinationConnection var1);

    public Value<Boolean> getUse81StylePolling();

    public void setUse81StylePolling(String var1);

    public void setUse81StylePolling(Boolean var1);

    public Value<String> getResourceAdapterJndiName();

    public void setResourceAdapterJndiName(String var1);
}

