/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.descriptors.ejbjar;

import oracle.eclipse.tools.weblogic.descriptors.ejbjar.ConcurrencyStrategyParam;
import oracle.eclipse.tools.weblogic.descriptors.ejbjar.EntityCachePolicy;
import oracle.eclipse.tools.weblogic.descriptors.ejbjar.IEntityClustering;
import oracle.eclipse.tools.weblogic.descriptors.ejbjar.IPersistence;
import oracle.eclipse.tools.weblogic.descriptors.ejbjar.IPool;
import oracle.eclipse.tools.weblogic.descriptors.ejbjar.ITimerDescriptor;
import oracle.eclipse.tools.weblogic.descriptors.ejbjar.IWeblogicEnterpriseBean;
import oracle.eclipse.tools.weblogic.descriptors.ejbjar.internal.CmpEntityEnabler;
import oracle.eclipse.tools.weblogic.descriptors.ejbjar.internal.EjbNameEntityValuesProvider;
import oracle.eclipse.tools.weblogic.descriptors.ejbjar.internal.EjbNameReadonlyEntityValuesProvider;
import oracle.eclipse.tools.weblogic.descriptors.ejbjar.internal.EntityCacheBinding;
import oracle.eclipse.tools.weblogic.descriptors.ejbjar.internal.EntityCacheChoiceBinding;
import oracle.eclipse.tools.weblogic.descriptors.ejbjar.internal.EntityCacheNameValuesProvider;
import org.eclipse.sapphire.ElementType;
import org.eclipse.sapphire.ImpliedElementProperty;
import org.eclipse.sapphire.Since;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.ValueProperty;
import org.eclipse.sapphire.modeling.annotations.DefaultValue;
import org.eclipse.sapphire.modeling.annotations.Documentation;
import org.eclipse.sapphire.modeling.annotations.Enablement;
import org.eclipse.sapphire.modeling.annotations.Image;
import org.eclipse.sapphire.modeling.annotations.Label;
import org.eclipse.sapphire.modeling.annotations.NumericRange;
import org.eclipse.sapphire.modeling.annotations.Required;
import org.eclipse.sapphire.modeling.annotations.Service;
import org.eclipse.sapphire.modeling.annotations.Services;
import org.eclipse.sapphire.modeling.annotations.Type;
import org.eclipse.sapphire.modeling.xml.annotations.CustomXmlValueBinding;
import org.eclipse.sapphire.modeling.xml.annotations.XmlBinding;

@Label(standard="entity bean")
@Image(path="images/descriptors/ejb/entity-bean.png")
public interface IEntityDescriptor
extends IWeblogicEnterpriseBean,
IPool,
ITimerDescriptor {
    public static final ElementType TYPE = new ElementType(IEntityDescriptor.class);
    @Service(impl=EjbNameEntityValuesProvider.class)
    public static final ValueProperty PROP_EJB_NAME = new ValueProperty(TYPE, IWeblogicEnterpriseBean.PROP_EJB_NAME);
    @XmlBinding(path="entity-descriptor/pool/max-beans-in-free-pool")
    public static final ValueProperty PROP_MAX_BEANS_IN_FREE_POOL = new ValueProperty(TYPE, IPool.PROP_MAX_BEANS_IN_FREE_POOL);
    @XmlBinding(path="entity-descriptor/pool/initial-beans-in-free-pool")
    public static final ValueProperty PROP_INITIAL_BEANS_IN_FREE_POOL = new ValueProperty(TYPE, IPool.PROP_INITIAL_BEANS_IN_FREE_POOL);
    @XmlBinding(path="entity-descriptor/pool/idle-timeout-seconds")
    public static final ValueProperty PROP_IDLE_TIMEOUT_SECONDS = new ValueProperty(TYPE, IPool.PROP_IDLE_TIMEOUT_SECONDS);
    @XmlBinding(path="entity-descriptor/timer-descriptor/persistent-store-logical-name")
    public static final ValueProperty PROP_PERSISTENT_STORE_LOGICAL_NAME = new ValueProperty(TYPE, ITimerDescriptor.PROP_PERSISTENT_STORE_LOGICAL_NAME);
    @Type(base=IEntityClustering.class)
    @XmlBinding(path="entity-descriptor")
    public static final ImpliedElementProperty PROP_ENTITY_CLUSTERING = new ImpliedElementProperty(TYPE, "EntityClustering");
    @Type(base=IPersistence.class)
    @XmlBinding(path="entity-descriptor")
    public static final ImpliedElementProperty PROP_PERSISTENCE = new ImpliedElementProperty(TYPE, "Persistence");
    @XmlBinding(path="entity-descriptor/invalidation-target/ejb-name")
    @Label(standard="invalidation target EJB name")
    @Services(value={@Service(impl=CmpEntityEnabler.class), @Service(impl=EjbNameReadonlyEntityValuesProvider.class)})
    @Documentation(content="The read-only entity bean to invalidate when this container-managed persistence entity bean is modified.[pbr/]Can only be specified for an EJB 2.n container-managed persistence entity beans.")
    public static final ValueProperty PROP_INVALIDATION_TARGET_EJB_NAME = new ValueProperty(TYPE, "InvalidationTargetEjbName");
    @Type(base=Boolean.class)
    @XmlBinding(path="entity-descriptor/enable-dynamic-queries")
    @Label(standard="enable dynamic queries")
    @DefaultValue(text="true")
    @Service(impl=CmpEntityEnabler.class)
    @Documentation(content="Sets to \"true\" to enable dynamic queries.[pbr/]Can only be specified for an EJB 2.n container-managed persistence entity beans.")
    public static final ValueProperty PROP_ENABLE_DYNAMIC_QUERIES = new ValueProperty(TYPE, "EnableDynamicQueries");
    @Type(base=EntityCachePolicy.class)
    @CustomXmlValueBinding(impl=EntityCacheChoiceBinding.class)
    @Label(standard="entity cache")
    @DefaultValue(text="ENTITY_CACHE")
    public static final ValueProperty PROP_ENTITY_CACHE = new ValueProperty(TYPE, "EntityCache");
    @Type(base=Integer.class)
    @XmlBinding(path="entity-descriptor/entity-cache/max-beans-in-cache")
    @Label(standard="max beans in cache")
    @NumericRange(min="1")
    @DefaultValue(text="1000")
    @Enablement(expr="${ EntityCache == 'ENTITY_CACHE' }")
    @Documentation(content="Specifies the maximum number of objects of this class that are allowed in memory. When \"max-bean-in-cache\" is reached, Oracle WebLogic Server passivates some EJB beans that have not recently been used by a client.")
    public static final ValueProperty PROP_MAX_BEANS_IN_CACHE = new ValueProperty(TYPE, "MaxBeansInCache");
    @Type(base=Integer.class)
    @XmlBinding(path="entity-descriptor/entity-cache/max-queries-in-cache")
    @Label(standard="max queries in cache")
    @NumericRange(min="0")
    @DefaultValue(text="100")
    @Enablement(expr="${ EntityCache == 'ENTITY_CACHE' }")
    @Documentation(content="Specifies the maximum number of read-only entity queries to cache at the bean level.")
    public static final ValueProperty PROP_MAX_QUERIES_IN_CACHE = new ValueProperty(TYPE, "MaxQueriesInCache");
    @Type(base=ConcurrencyStrategyParam.class)
    @XmlBinding(path="entity-descriptor/entity-cache/concurrency-strategy")
    @Label(standard="concurrency strategy")
    @Enablement(expr="${ EntityCache == 'ENTITY_CACHE' }")
    @DefaultValue(text="Database")
    @Documentation(content="Specifies how the container should manage concurrent access to an entity bean. [ul][li]Exclusive: causes Oracle WebLogic Server to place an exclusive lock on cached entity EJB instances when the bean is associated with a transaction. Other requests for the EJB instance are blocked until the transaction completes. This option was the default locking behavior for WebLogic Server 3.1 through 5.1.[/li][li]Database: causes Oracle WebLogic Server to defer locking requests for an entity EJB to the underlying datastore. With the \"Database\" concurrency strategy, Oracle WebLogic Server allocates a separate entity bean instance and allows locking and caching to be handled by the database. This is the default option.[/li][li]ReadOnly: is used for read-only entity beans. Activates a new instance for each transaction so that requests proceed in parallel. Oracle WebLogic Server calls the ejbLoad() method for \"ReadOnly\" beans are based on the \"read-timeout-seconds\" parameter.[/li][li]Optimistic: holds no locks in the EJB container or database during a transaction. The EJB container verifies that none of the data updated by a transaction has changed before committing the transaction. If any updated data has changed, the EJB container rolls back the transaction.[/li][/ul]")
    public static final ValueProperty PROP_CONCURRENCY_STRATEGY = new ValueProperty(TYPE, "ConcurrencyStrategy");
    @Type(base=Boolean.class)
    @XmlBinding(path="entity-descriptor/entity-cache/disable-ready-instances")
    @Label(standard="disable ready instances")
    @DefaultValue(text="false")
    @Enablement(expr="${ EntityCache == 'ENTITY_CACHE' }")
    @Since(value="10.3")
    @Documentation(content="When set to \"true\", the EJB bean can be deployed from multiple Oracle WebLogic Servers in a cluster. ")
    public static final ValueProperty PROP_DISABLE_READY_INSTANCES = new ValueProperty(TYPE, "DisableReadyInstances");
    @XmlBinding(path="entity-descriptor/entity-cache-ref/entity-cache-name")
    @Label(standard="entity cache name")
    @Required
    @Enablement(expr="${ EntityCache == 'ENTITY_CACHE_REF' }")
    @Service(impl=EntityCacheNameValuesProvider.class)
    @Documentation(content="Specifies the name assigned to an application-level entity cache in the weblogic-application.xml file.")
    public static final ValueProperty PROP_ENTITY_CACHE_NAME = new ValueProperty(TYPE, "EntityCacheName");
    @Type(base=Integer.class)
    @CustomXmlValueBinding(impl=EntityCacheBinding.class)
    @Label(standard="idle timeout (secs)")
    @NumericRange(min="1")
    @DefaultValue(text="600")
    @Documentation(content="Defines the maximum length of time an EJB bean should remain in the cache.")
    public static final ValueProperty PROP_IDLE_TIMEOUT_SECONDS2 = new ValueProperty(TYPE, "IdleTimeoutSeconds2");
    @Type(base=Integer.class)
    @CustomXmlValueBinding(impl=EntityCacheBinding.class)
    @Label(standard="read timeout (secs)")
    @NumericRange(min="1")
    @DefaultValue(text="600")
    @Documentation(content="Specifies the number of seconds between ejbLoad() calls on a read-only entity bean. A value of 0 causes Oracle WebLogic Server to call the ejbLoad() method only when the bean is brought into the cache.")
    public static final ValueProperty PROP_READ_TIMEOUT_SECONDS = new ValueProperty(TYPE, "ReadTimeoutSeconds");
    @Type(base=ConcurrencyStrategyParam.class)
    @XmlBinding(path="entity-descriptor/entity-cache-ref/concurrency-strategy")
    @Label(standard="concurrency strategy")
    @Enablement(expr="${ EntityCache == 'ENTITY_CACHE_REF' }")
    @DefaultValue(text="Database")
    @Documentation(content="Specifies how the container should manage concurrent access to an entity bean.")
    public static final ValueProperty PROP_CONCURRENCY_STRATEGY2 = new ValueProperty(TYPE, "ConcurrencyStrategy2");
    @Type(base=Boolean.class)
    @CustomXmlValueBinding(impl=EntityCacheBinding.class)
    @Label(standard="cache between transactions")
    @DefaultValue(text="false")
    @Documentation(content="Specify \"true\" to enable the EJB container to perform long-term caching of the data. Specify \"false\" to enable the EJB container to perform short term caching of the data.")
    public static final ValueProperty PROP_CACHE_BETWEEN_TRANSACTIONS = new ValueProperty(TYPE, "CacheBetweenTransactions");
    @Type(base=Integer.class)
    @XmlBinding(path="entity-descriptor/entity-cache-ref/estimated-bean-size")
    @Label(standard="estimated bean size (bytes)")
    @Enablement(expr="${ EntityCache == 'ENTITY_CACHE_REF' }")
    @NumericRange(min="1")
    @DefaultValue(text="100")
    @Documentation(content="Specifies the estimated average size of the instances of an entity bean in bytes.")
    public static final ValueProperty PROP_ESTIMATED_BEAN_SIZE = new ValueProperty(TYPE, "EstimatedBeanSize");

    public IEntityClustering getEntityClustering();

    public IPersistence getPersistence();

    public Value<String> getInvalidationTargetEjbName();

    public void setInvalidationTargetEjbName(String var1);

    public Value<Boolean> getEnableDynamicQueries();

    public void setEnableDynamicQueries(String var1);

    public void setEnableDynamicQueries(Boolean var1);

    public Value<EntityCachePolicy> getEntityCache();

    public void setEntityCache(String var1);

    public void setEntityCache(EntityCachePolicy var1);

    public Value<Integer> getMaxBeansInCache();

    public void setMaxBeansInCache(String var1);

    public void setMaxBeansInCache(Integer var1);

    public Value<Integer> getMaxQueriesInCache();

    public void setMaxQueriesInCache(String var1);

    public void setMaxQueriesInCache(Integer var1);

    public Value<ConcurrencyStrategyParam> getConcurrencyStrategy();

    public void setConcurrencyStrategy(String var1);

    public void setConcurrencyStrategy(ConcurrencyStrategyParam var1);

    public Value<Boolean> getDisableReadyInstances();

    public void setDisableReadyInstances(String var1);

    public void setDisableReadyInstances(Boolean var1);

    public Value<String> getEntityCacheName();

    public void setEntityCacheName(String var1);

    public Value<Integer> getIdleTimeoutSeconds2();

    public void setIdleTimeoutSeconds2(String var1);

    public void setIdleTimeoutSeconds2(Integer var1);

    public Value<Integer> getReadTimeoutSeconds();

    public void setReadTimeoutSeconds(String var1);

    public void setReadTimeoutSeconds(Integer var1);

    public Value<ConcurrencyStrategyParam> getConcurrencyStrategy2();

    public void setConcurrencyStrategy2(String var1);

    public void setConcurrencyStrategy2(ConcurrencyStrategyParam var1);

    public Value<Boolean> getCacheBetweenTransactions();

    public void setCacheBetweenTransactions(String var1);

    public void setCacheBetweenTransactions(Boolean var1);

    public Value<Integer> getEstimatedBeanSize();

    public void setEstimatedBeanSize(String var1);

    public void setEstimatedBeanSize(Integer var1);
}

